% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluateFitness.R
\name{evaluateFitness}
\alias{evaluateFitness}
\title{Computes the fitness values for each member of a given population.}
\usage{
evaluateFitness(population, fitness.fun, task, control)
}
\arguments{
\item{population}{[\code{list}]\cr
Population.}

\item{fitness.fun}{[\code{function}]\cr
Fitness function.}

\item{task}{[\code{ecr_optimization_task}]\cr
Optimization task.}

\item{control}{[\code{ecr_control}]\cr
Control object containing all operators and further parameters.
See \code{\link{setupECRControl}} and \code{\link{setupEvolutionaryOperators}}.}
}
\value{
[\code{matrix}].
}
\description{
This function expects a population, computes the fitness and
returns the matrix of fitness values. This function makes use of
\code{\link[parallelMap]{parallelMap}} to allow parallelization of fitness
evaluation.
Keep in mind, that the return value is a 1xn matrix in case of single-objective
optimization.
}

