% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emoa.indicators.R
\name{computeEpsilonIndicator}
\alias{computeEpsilonIndicator}
\alias{computeHypervolumeIndicator}
\alias{computeR1Indicator}
\alias{computeR2Indicator}
\alias{computeR3Indicator}
\title{Computation of the unary epsilon-indicator.}
\usage{
computeEpsilonIndicator(points, ref.points)

computeHypervolumeIndicator(points, ref.points, ref.point = NULL)

computeR1Indicator(points, ref.points, ideal.point = NULL,
  nadir.point = NULL, lambda = NULL, utility = "tschebycheff")

computeR2Indicator(points, ref.points, ideal.point = NULL,
  nadir.point = NULL, lambda = NULL, utility = "tschebycheff")

computeR3Indicator(points, ref.points, ideal.point = NULL,
  nadir.point = NULL, lambda = NULL, utility = "tschebycheff")
}
\arguments{
\item{points}{[\code{matrix}]\cr
Matrix of points.}

\item{ref.points}{[\code{matrix}]\cr
Set of reference points.}

\item{ref.point}{[\code{numeric}]\cr
A single reference point used e.g. for the computation of the hypervolume
indicator via \code{computeHypervolumeIndicator}. If \code{NULL} the
nadir point of the union of the \code{points} and \code{ref.points} is used.}

\item{ideal.point}{[\code{numeric}]\cr
The utopia point of the true Pareto front, i.e., each component of the point
contains the best value if the other objectives are neglected.}

\item{nadir.point}{[\code{numeric}]\cr
Nadir point of the true Pareto front.}

\item{lambda}{[\code{integer(1)}]\cr
Number of weight vectors to use in estimating the utility function.}

\item{utility}{[\code{character(1)}]\cr
Name of the utility function to use. Must be one of \dQuote{weightedsum},
\dQuote{tschebycheff} or \dQuote{augmented tschbycheff}.}
}
\value{
[\code{numeric(1)}] Epsilon indicator.
}
\description{
Functions for the computation of unary and binary measures which
are useful for the evaluation of the performace of EMOAs. See the references
section for literature on these indicators.

Given a set of points \code{points}, \code{computeEpsilonIndicator} computes the
unary epsilon-indicator provided a set of reference points \code{ref.points}.

The \code{computeHypervolumeIndicator} function computes the hypervolume indicator
Hyp(X, R, r). Given a set of point X (\code{points}), another set of reference
points R (\code{ref.points}) (which maybe the true Pareto front) and a reference
point r (\code{ref.point}) it is defined as Hyp(X, R, r) = HV(X, r) - HV(R, r).
}

