% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/revealed_comparative_advantage.R
\name{ec_rca}
\alias{ec_rca}
\title{Revealed Comparative Advantage (RCA)}
\usage{
ec_rca(data = NULL, c = "country", p = "product", v = "value",
  cutoff = 1, discrete = TRUE, tbl = FALSE)
}
\arguments{
\item{data}{tibble/data.frame in long format, it must contain the
columns c (character/factor), p (character/factor) and export
v (numeric)}

\item{c}{string to indicate the column that contains exporting
countries (e.g. "reporter_iso")}

\item{p}{string to indicate the column that contains exported ps
(e.g. "p_code")}

\item{v}{string to indicate the column that contains traded vs
(e.g. "trade_v_usd")}

\item{cutoff}{when set to TRUE all the vs lower than the specified cutoff
will be converted to zero and to one in other case, numeric (default set
to 1)}

\item{discrete}{when set to TRUE it will convert all the Revealed Comparative
Advantage vs
to zero or one based on the cutoff v (default set to TRUE)}

\item{tbl}{when set to TRUE the output will be a tibble instead of a
matrix (default set to FALSE)}
}
\description{
Revealed Comparative Advantage (RCA)
}
\examples{
ec_rca(
  data = ec_trade_1962,
  tbl = TRUE
)

}
\references{
For more information on revealed comparative advantage and its uses see:

\insertRef{atlas2014}{economiccomplexity}
}
\keyword{functions}
