% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/horse_race.R
\name{horse_race}
\alias{horse_race}
\title{Compare the explanatory power of parameter.dependent network centrality measures with those of standard measures of network centrality.}
\usage{
horse_race(
  formula = formula(),
  centralities = c("indegree", "outdegree", "degree", "betweenness", "incloseness",
    "outcloseness", "closeness", "eigenvector"),
  directed = FALSE,
  weighted = FALSE,
  normalization = FALSE,
  data = list(),
  unobservables = list(),
  G = list(),
  model = c("model_A", "model_B"),
  estimation = c("NLLS", "MLE"),
  endogeneity = FALSE,
  first_step = NULL,
  exclusion_restriction = NULL,
  start.val = NULL,
  to_weight = NULL,
  time_fixed_effect = NULL,
  ind_fixed_effect = NULL,
  mle_controls = NULL,
  kappa = NULL,
  delta = NULL
)
}
\arguments{
\item{formula}{an object of class \code{formula}: a symbolic description of the model to be fitted. The constant (i.e. intercept) and the autogressive parameter needs not to be specified.}

\item{centralities}{\ifelse{latex}{at least one of \code{c("indegree","outdegree","degree", "betweenness", "incloseness",} \cr \code{"outcloseness", "closeness", "eigenvector")}.}{at least one of \code{c("indegree","outdegree","degree", "betweenness", "incloseness", "outcloseness", "closeness", "eigenvector")}.}}

\item{directed}{logical. \code{TRUE} if the social network is directed, \code{FALSE} otherwise.}

\item{weighted}{logical. \code{TRUE} if the social network is weighted, \code{FALSE} otherwise.}

\item{normalization}{\ifelse{latex}{Default is NULL. Alternatively, it can be set to \code{c("bygraph","bycomponent",}\cr \code{"bymaxcomponent","bymaxgraph")}. See details.}{Default is NULL. Alternatively, it can be set to \code{c("bygraph","bycomponent","bymaxcomponent","bymaxgraph")}. See details.}}

\item{data}{an object of class \code{data.frame} containing the variables in the model. If data are longitudinal, observations must be ordered by time period and then by individual.}

\item{unobservables}{a numeric vector used to obtain an unbiased estimate of the parameter.dependent centrality when the network is endogenous. See details.}

\item{G}{an object of class \code{Matrix} representing the social network. Row and column names must be specified and match the order of the observations in \code{data}.}

\item{model}{string. One of \code{c("model_A","model_B")}. See details.}

\item{estimation}{string. One of \code{c("NLLS","MLE")}. They are used to implement respectively a non-linear least square and a maximum likelihood estimator.}

\item{endogeneity}{logical. Default is \code{FALSE}. If \code{TRUE}, \code{net_dep} implements a two-step correction procedure to control for the endogeneity of the network.}

\item{first_step}{\ifelse{latex}{Default is NULL. If \code{endogeneity = TRUE}, it requires to specify one of \code{c("standard",}\cr\code{"fe", "shortest", "coauthors", "degree")}. See details.}{Default is NULL. If \code{endogeneity = TRUE}, it requires to specify one of \code{c("standard","fe", "shortest", "coauthors", "degree")}. See details.}}

\item{exclusion_restriction}{an object of class \code{Matrix} representing the exogenous matrix used to instrument the endogenous social network, if \code{unobservables} is non-\code{NULL}.  Row and column names must be specified and match the order of the observations in \code{data}.}

\item{start.val}{an optional list containing the starting values for the estimations. Object names must match the names provided in \code{formula}. It is also required to specify the value of both the constant and the decay parameter(s).}

\item{to_weight}{an optional vector of weights to be used in the fitting process to indicate that different observations have different variances. Should be \code{NULL} or a numeric vector. If non-\code{NULL}, weighted non-linear least squares (if \code{estimation = "NLLS"}) or weighted maximum likelihood  (if \code{estimation = "MLE"}) is estimated.}

\item{time_fixed_effect}{an optional string. It indicates the name of the time index used in formula. It is used for models with longitudinal data.}

\item{ind_fixed_effect}{an optional string. Default is \code{NULL}. It indicates the name of the individual index contained in the data. If provided, individual fixed effects are automatically added to the \code{formula} of the main equation. If \code{endogeneity = TRUE}, the field \code{first_step} is overridden, and automatically set equal to \code{"fe"}. It is used for models with longitudinal data.}

\item{mle_controls}{a list allowing the user to set upper and lower bounds for control variables in MLE estimation and the variance for the ML estimator. See details.}

\item{kappa}{a normalization level with default equals 1 used in MLE estimation.}

\item{delta}{Default is \code{NULL}. To be used when \code{estimation = "NLLS"}. It has to be a number between zero (included) and one (excluded). When used, \code{econet} performs a constrained NLLS estimation. In this case, the estimated peer effect parameter, taken in absolute value, is forced to be higher than zero and lower than the spectral radius of \code{G}. Specifically, \code{delta} is a penalizing factor, decreasing the goodness of fit of the NLLS estimation, when the peer effect parameter approaches one of the two bounds. Observe that very high values of \code{delta} may cause NLLS estimation not to converge.}
}
\value{
A list of two objects:
\itemize{
\item A list of estimates, each one setting the decay parameter to zero, and adding one of the \code{centralities} to the specification of \code{formula}. The last object adds to \code{formula} all the selected \code{centralities} and the decay parameter is set different from zero.
\item An object of class \code{data.frame} containing the computed centrality measures.
\item A list of first-step estimations used to correct the effect of centrality measures when the network is endogenous.
}
}
\description{
Compare the explanatory power of parameter.dependent network centrality measures with those of standard measures of network centrality.
}
\details{
A number of different normalization are available to the user:
\itemize{
\item \code{bygraph} and \code{bycomponent} are used to divide \emph{degree} and \emph{closeness} centrality by \eqn{n - 1}, and \emph{betweenness} centrality by \eqn{(n - 1) * (n - 2)} if \code{directed = TRUE}, or by \eqn{(n - 1)*(n - 2)/2} if \code{directed = FALSE}. In the former case (i.e. \code{bygraph}), \emph{n} is equal to the number of nodes in the network In the latter case (i.e. \code{bycomponent}), \emph{n} is equal to the number of nodes of the component in which the node is embedded.
\item \code{bymaxgraph} and \code{bymaxcomponent} are used to divide \emph{degree}, \emph{betweenness} and \emph{closeness} centrality by the maximum value of the centrality of the network (\code{bymaxgraph}) or component (\code{bymaxcomponent}) in which the node is embedded.
}
If the network is endogenous, the user is required to run separately \code{net_dep} and extract from the resulting object the vector of unobservables necessary for obtaining an unbiased estimate of the parameter.dependent centrality. This vector can be passed through the argument \code{unobservables}.\cr
If \code{endogeneity = TRUE}, a two-step estimation is implemented to control for network endogeneity. The argument \code{first_step} is used to control for the specification of the first-step model, e.g.:
\itemize{
\item \code{first_step = "standard"} is used when agents' connection are predicted by the differences in their characteristics (i.e. those on the right hand side of \code{formula}), and an \code{exclusion_restriction}: i.e., their connections in a different network.
\item \code{first_step = "fe"} adds individual fixed effects to the \code{standard} model, as in Graham (2017).
\item \code{first_step = "shortest"} adds to the \code{standard} model, the shortest distance between \emph{i} and \emph{j}, excluding the link between \emph{i} and \emph{j} itself, as in Fafchamps et al (2010).
\item \code{first_step = "coauthor"} adds to the \code{standard} model, the number of shared connections between \emph{i} and \emph{j}, as in Graham (2015).
\item \code{first_step = "degree"} adds to the \code{standard} model, the difference in the degree centrality of \emph{i} and \emph{j}.
}
For additional details, see the vignette.
}
\examples{
\donttest{
# Load data
data("db_cosponsor")
data("G_alumni_111")
db_model_B <- db_cosponsor
G_model_B <- G_cosponsor_111
G_exclusion_restriction <- G_alumni_111
are_factors <- c("party", "gender", "nchair")
db_model_B[are_factors] <- lapply(db_model_B[are_factors], factor)

# Specify formula
f_model_B <- formula("les ~gender + party + nchair")

# Specify starting values
starting <- c(alpha = 0.214094,
             beta_gender1 = -0.212706,
             beta_party1 = 0.478518,
             beta_nchair1 = 3.09234,
             beta_betweenness = 7.06287e-05,
             phi = 0.344787)

# Fit model
horse_model_B <- horse_race(formula = f_model_B,
              centralities = "betweenness",
              directed = TRUE, weighted = TRUE,
              data = db_model_B, G = G_model_B,
              model = "model_B", estimation = "NLLS",
              start.val = starting)

# Store and print results
summary(horse_model_B)
summary(horse_model_B, centrality = "betweenness")
horse_model_B$centrality
}
# WARNING, This toy example is provided only for runtime execution.
# Please refer to previous examples for sensible calculations.
data("db_alumni_test")
data("G_model_A_test")
db_model <- db_alumni_test
G_model <- G_model_A_test
f_model <- formula("les ~ dw")
horse_model_test <- horse_race(formula = f_model, centralities = "betweenness",
                            directed = TRUE, weighted = FALSE, normalization = NULL,
                            data = db_model, unobservables = NULL, G = G_model,
                            model = "model_A", estimation = "NLLS",
                            start.val = c(alpha = -0.31055275,
                                          beta_dw = 1.50666982,
                                          beta_betweenness = 0.09666742,
                                          phi = 16.13035695))
summary(horse_model_test)
}
\references{
Battaglini M., V. Leone Sciabolazza, E. Patacchini, S. Peng (2020), "Econet: An R package for the Estimation of parameter-dependent centrality measures", Mimeo. \cr
}
\seealso{
\code{\link{net_dep}}
}
