% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_taxon_ancillary.R
\name{create_taxon_ancillary}
\alias{create_taxon_ancillary}
\title{Create the taxon_ancillary table}
\usage{
create_taxon_ancillary(
  L0_flat,
  taxon_id,
  datetime = NULL,
  variable_name,
  unit = NULL,
  author = NULL
)
}
\arguments{
\item{L0_flat}{(tbl_df, tbl, data.frame) The fully joined source L0 dataset, in "flat" format (see details).}

\item{taxon_id}{(character) Column in \code{L0_flat} containing the identifier assigned to each unique organism at the observation level.}

\item{datetime}{(character) An optional in \code{L0_flat} containing the date, and if applicable time, of ancillary location data following the ISO-8601 standard format (e.g. YYYY-MM-DD hh:mm:ss).}

\item{variable_name}{(character) Columns in \code{L0_flat} containing the ancillary taxon data.}

\item{unit}{(character) An optional column in \code{L0_flat} containing the units of each \code{variable_name} following the column naming convention: unit_<variable_name> (e.g. "unit_average_length").}

\item{author}{(character) An optional column in \code{L0_flat} containing the person associated with identification of taxa in the taxon table.}
}
\value{
(tbl_df, tbl, data.frame) The taxon_ancillary table.
}
\description{
Create the taxon_ancillary table
}
\details{
This function collects specified columns from \code{L0_flat}, converts into long (attribute-value) form by gathering \code{variable_name}. Regular expression matching joins \code{unit} to any associated \code{variable_name} and is listed in the resulting table's "unit" column.

"flat" format refers to the fully joined source L0 dataset in "wide" form with the exception of the core observation variables, which are in "long" form (i.e. using the variable_name, value, unit columns of the observation table). This "flat" format is the "widest" an L1 ecocomDP dataset can be consistently spread due to the frequent occurrence of L0 source datasets with > 1 core observation variable.
}
\examples{
flat <- ants_L0_flat

taxon_ancillary <- create_taxon_ancillary(
  L0_flat = flat,
  taxon_id = "taxon_id",
  variable_name = c(
    "subfamily", "hl", "rel", "rll", "colony.size", 
    "feeding.preference", "nest.substrate", "primary.habitat", 
    "secondary.habitat", "seed.disperser", "slavemaker.sp", 
    "behavior", "biogeographic.affinity", "source"),
  unit = c("unit_hl", "unit_rel", "unit_rll"))

taxon_ancillary

}
