% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecic_plot.R
\name{ecic_plot}
\alias{ecic_plot}
\title{Plot an extended changes-in-changes model}
\usage{
ecic_plot(
  object,
  es_type = c("aggregated", "for_quantiles", "for_periods"),
  perc_plot = NULL,
  periods_plot = NULL,
  xlab = NULL,
  ylab = "QTE \\n",
  ylim = NULL,
  size = 2,
  zero_line = FALSE,
  legend_title = "Percentiles"
)
}
\arguments{
\item{object}{An \code{ecic_table} object.}

\item{es_type}{If an event study was estimated with \code{ecic}, you can choose the
style of the ES plot. "aggregated" puts everything in one plot. "for_quantiles"
generates one plot for each percentile. "for_periods" generates one plot for each period.}

\item{perc_plot}{Which percentiles to plot.}

\item{periods_plot}{Which periods to plot.}

\item{xlab}{Alternative x-axis label}

\item{ylab}{Alternative y-axis label.}

\item{ylim}{Define the y-axis limits.}

\item{size}{Size of the point estimates.}

\item{zero_line}{Add a horizontal line at zero.}

\item{legend_title}{Change the title of the legend.}
}
\value{
A \code{ggplot2} object.
}
\description{
Plots the results of the \code{ecic} model, either along
the percentiles or in an event-study fashion.
}
