% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train_esn.R
\name{train_esn}
\alias{train_esn}
\title{Train an Echo State Network}
\usage{
train_esn(
  y,
  lags = 1,
  inf_crit = "bic",
  n_diff = NULL,
  n_states = NULL,
  n_models = NULL,
  n_initial = NULL,
  n_seed = 42,
  alpha = 1,
  rho = 1,
  density = 0.5,
  lambda = c(1e-04, 2),
  scale_win = 0.5,
  scale_wres = 0.5,
  scale_inputs = c(-0.5, 0.5)
)
}
\arguments{
\item{y}{Numeric vector containing the response variable.}

\item{lags}{Integer vectors with the lags associated with the input variable.}

\item{inf_crit}{Character value. The information criterion used for variable selection \code{inf_crit = c("aic", "aicc", "bic")}.}

\item{n_diff}{Integer vector. The nth-differences of the response variable.}

\item{n_states}{Integer value. The number of internal states per reservoir.}

\item{n_models}{Integer value. The maximum number of (random) models to train for model selection.}

\item{n_initial}{Integer value. The number of observations of internal states for initial drop out (throw-off).}

\item{n_seed}{Integer value. The seed for the random number generator (for reproducibility).}

\item{alpha}{Numeric value. The leakage rate (smoothing parameter) applied to the reservoir.}

\item{rho}{Numeric value. The spectral radius for scaling the reservoir weight matrix.}

\item{density}{Numeric value. The connectivity of the reservoir weight matrix (dense or sparse).}

\item{lambda}{Numeric vector. Lower and upper bound of lambda sequence for ridge regression.}

\item{scale_win}{Numeric value. The lower and upper bound of the uniform distribution for scaling the input weight matrix.}

\item{scale_wres}{Numeric value. The lower and upper bound of the uniform distribution for scaling the reservoir weight matrix.}

\item{scale_inputs}{Numeric vector. The lower and upper bound for scaling the time series data.}
}
\value{
A \code{list} containing:
   \itemize{
      \item{\code{actual}: Numeric vector containing the actual values.}
      \item{\code{fitted}: Numeric vector containing the fitted values.}
      \item{\code{resid}: Numeric vector containing the residuals.}
      \item{\code{states_train}: Numeric matrix containing the internal states.}
      \item{\code{method}: A \code{list} containing several objects and meta information of the trained ESN (weight matrices, hyperparameters, model metrics, etc.).}
      }
}
\description{
This function trains an Echo State Network (ESN) to a
  univariate time series.
}
\examples{
xdata <- as.numeric(AirPassengers)
xmodel <- train_esn(y = xdata)
summary(xmodel)
}
