% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast_esn.R
\name{forecast_esn}
\alias{forecast_esn}
\title{Forecast a trained Echo State Network}
\usage{
forecast_esn(object, n_ahead = 18)
}
\arguments{
\item{object}{An object of class \code{esn}. The result of a call to \code{train_esn()}.}

\item{n_ahead}{Integer value. The number of periods for forecasting (i.e. forecast horizon).}
}
\value{
A \code{list} containing:
   \itemize{
      \item{\code{point}: Numeric vector containing the point forecasts.}
      \item{\code{actual}: Numeric vector containing the actual values.}
      \item{\code{fitted}: Numeric vector containing the fitted values.}
      \item{\code{n_ahead}: Integer value. The number of periods for forecasting (forecast horizon).}
      \item{\code{model_spec}: Character value. The model specification as string.}
      }
}
\description{
Forecast an Echo State Network from a trained model.
}
\examples{
xdata <- as.numeric(AirPassengers)
xmodel <- train_esn(y = xdata)
xfcst <- forecast_esn(xmodel, n_ahead = 12)
plot(xfcst)
}
