% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echoice2.R
\name{ec_demcurve}
\alias{ec_demcurve}
\title{Create demand curves}
\usage{
ec_demcurve(
  ec_long,
  focal_product,
  rel_pricerange,
  dem_fun,
  draws,
  epsilon_not = NULL
)
}
\arguments{
\item{ec_long}{choice scenario (discrete or volumetric)}

\item{focal_product}{Logical vector picking the focal product for which to create a demand curve}

\item{rel_pricerange}{Price range, relative to base case price; this is used to create demand curve}

\item{dem_fun}{demand function (e.g., \code{dd_prob} for HMNL or \code{vd_dem_vdm} for volumetric demand). For discrete choice, use choice probabilities instead of choice predictions.}

\item{draws}{ec-draws object (e.g., output from \code{dd_est_hmnl} or \code{vd_est_vd})}

\item{epsilon_not}{(optional) error realisatins (this helps make curves look smother for voumetric models)}
}
\value{
List containing aggregate demand quantities for each scenario defined by \code{rel_pricerange}
}
\description{
This helper function creates demand curves
}
\examples{
\donttest{
data(icecream)
#run MCMC sampler (use way more than 50 draws for actual use)
icecream_est <- icecream \%>\% dplyr::filter(id<100) \%>\% 
vd_est_vdm(R=20, keep=1)
#demand at different price points
dem_scenarios<-
ec_demcurve(icecream\%>\% dplyr::filter(id<100),
 icecream\%>\% dplyr::filter(id<100) \%>\% pull('Brand')=="Store",
 c(.75,1,1.25),vd_dem_vdm,icecream_est)
#optional plot
# dem_scenarios \%>\% 
#   do.call('rbind',.) \%>\%
#   ggplot(aes(x=scenario,y=`E(demand)`,color=Flavor)) + geom_line()
}

}
\seealso{
\code{\link[=ec_gen_err_normal]{ec_gen_err_normal()}} to generate error realization from Normal distribution,
\code{\link[=ec_gen_err_ev1]{ec_gen_err_ev1()}} to generate error realization from EV1 distribution
}
