% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echarty.R
\name{ec.init}
\alias{ec.init}
\title{Initialize command}
\usage{
ec.init(
  df = NULL,
  preset = TRUE,
  ctype = "scatter",
  tl.series = NULL,
  width = NULL,
  height = NULL,
  ...
)
}
\arguments{
\item{df}{A data.frame to be preset as \href{https://echarts.apache.org/en/option.html#dataset}{dataset}, default NULL \cr
By default the first column is for X values, second column is for Y, and third is for Z when in 3D.\cr
Best practice is to have the grouping column placed last. Grouping column cannot be used as axis.\cr
Timeline requires a \emph{grouped data.frame} to build its \href{https://echarts.apache.org/en/option.html#options}{options}.\cr
If grouping is on multiple columns, only the first one is used to determine settings.}

\item{preset}{Build preset xAxis,yAxis,serie for 2D, or grid3D,xAxis3D,yAxis3D,zAxis3D for 3D, default TRUE (enable).}

\item{ctype}{Chart type of series. Default is 'scatter'. Set to NULL to disable series preset.}

\item{tl.series}{A list to build a timeline or NULL(default). The list defines options \href{https://echarts.apache.org/en/option.html#series}{series} and their attributes. \cr
The only required attribute is \href{https://echarts.apache.org/en/option.html#series-line.encode}{encode}.\cr
\emph{encode} defines which data columns names to use for the axes: \cr
\itemize{
\item set \emph{x} and \emph{y} for coordinateSystem \emph{cartesian2d}
\item set \emph{lng} and \emph{lat} for coordinateSystem \emph{geo}
\item set \emph{radius} and \emph{angle} for coordinateSystem \emph{polar}
\item set \emph{value} and \emph{itemName} for \emph{pie} chart
\item set \emph{value} and \emph{name} for \emph{map} chart
}

Attribute \emph{coordinateSystem} is not set by default and depends on chart \emph{type}.\cr
Custom attribute \emph{groupBy}, a \emph{df} column name, can create series groups inside each timeline step.
A grouped \emph{df} must be present, with group column providing the \href{https://echarts.apache.org/en/option.html#timeline.data}{timeline data}.
Auto-generated \emph{timeline} and \emph{options} will be preset for the chart.\cr
\emph{tl.series} cannot be used for hierarchical charts like graph,tree,treemap,sankey. Chart options/timeline have to be built directly, see \href{https://helgasoft.github.io/echarty/uc4.html}{example}.}

\item{width, height}{A valid CSS unit (like \code{'100\%'},
\code{'500px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{...}{other arguments to pass to the widget. \cr
Custom echarty widget arguments include: \cr
\itemize{
\item elementId - Id of the widget, default is NULL(auto-generated)
\item load - name(s) of plugin(s) to load. A character vector or comma-delimited string. default NULL.
\item ask - prompt user before downloading plugins when \emph{load} is present, FALSE by default
\item js - single string or a vector with JavaScript expressions to evaluate.\cr
First expression is evaluated before chart initialization. \cr
Second is evaluated with exposed object \emph{opts}. \cr
Third is evaluated with exposed \emph{chart} object after \emph{opts} have been set.
\item renderer - 'canvas'(default) or 'svg'
\item locale - 'EN'(default) or 'ZH'. Use predefined or custom \href{https://gist.github.com/helgasoft/0618c6537c45bfd9e86d3f9e1da497b8}{like so}.
\item useDirtyRect - enable dirty rectangle rendering or not, FALSE by default, see \href{https://echarts.apache.org/en/api.html#echarts.init}{here}
}}
}
\value{
A widget to plot, or to save and expand with more features.
}
\description{
Required to build a chart. In most cases this will be the only command necessary.
}
\details{
Command \emph{ec.init} creates a widget with \link[htmlwidgets]{createWidget}, then adds some ECharts features to it.\cr
When \emph{ec.init} is chained after a data.frame, a \href{https://echarts.apache.org/en/option.html#dataset}{dataset} is preset. \cr
When data.frame is grouped and \emph{ctype} is not null, more datasets with legend and series are also preset. Grouped series are preset as type \emph{scatter}. \cr
Plugin '3D' presets will not work for 'scatterGL'. Instead, use \emph{preset=FALSE} and set explicitly \emph{xAxis,yAxis}. \cr
Plugins 'leaflet' and 'world' preset zoom=6 and center to the mean of all coordinates. \cr
Users can delete or overwrite any presets as needed. \cr

Built-in plugins: \cr
\itemize{
\item leaflet - Leaflet maps with customizable tiles, see \href{https://github.com/gnijuohz/echarts-leaflet#readme}{source}\cr
\item world - world map with country boundaries, see \href{https://github.com/apache/echarts/tree/master/test/data/map/js}{source} \cr
\item lottie - support for \href{https://lottiefiles.com}{lotties} \cr
\item custom - renderers for \link{ecr.band} and \link{ecr.ebars} \cr
Plugins with one-time installation: \cr
\item 3D - 3D charts and WebGL acceleration, see \href{https://github.com/ecomfe/echarts-gl}{source} and \href{https://echarts.apache.org/en/option-gl.html#series}{docs} \cr
\item liquid - liquid fill, see \href{https://github.com/ecomfe/echarts-liquidfill}{source}  \cr
\item gmodular - graph modularity, see \href{https://github.com/ecomfe/echarts-graph-modularity}{source}  \cr
\item wordcloud - cloud of words, see \href{https://github.com/ecomfe/echarts-wordcloud}{source} \cr
or install your own third-party plugins.\cr
}

Crosstalk:\cr
Parameter \emph{df} should be of type \link[crosstalk]{SharedData}, see \href{https://helgasoft.github.io/echarty/gallery.html#crosstalk-2d}{more info}.\cr
It should NOT have string row names. Use \link[tibble]{rownames} to remove or convert to column.\cr
Enabling \emph{crosstalk} will generate an additional dataset called \emph{Xtalk} and bind the first serie to it if \emph{datasetId} not set.\cr
}
\examples{
 # basic scatter chart from a data.frame, using presets
cars |> ec.init()
 
 # a timeline with two series and autoPlay
p <- iris |> dplyr::group_by(Species) |> ec.init(
  legend= list(show=TRUE),
  tl.series= list(
    encode=list(x=NULL, y=c('Sepal.Width', 'Petal.Length')),
    markPoint = list(data=list(list(type='max'), list(type='min')))
  )
) # |> ec.upd({...})
p$x$opts$timeline <- append(p$x$opts$timeline, list(autoPlay=TRUE))
p

}
