% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R, R/add_.R
\name{e_line}
\alias{e_line}
\alias{e_line_}
\title{Line}
\usage{
e_line(
  e,
  serie,
  bind,
  name = NULL,
  legend = TRUE,
  y_index = 0,
  x_index = 0,
  coord_system = "cartesian2d",
  ...
)

e_line_(
  e,
  serie,
  bind = NULL,
  name = NULL,
  legend = TRUE,
  y_index = 0,
  x_index = 0,
  coord_system = "cartesian2d",
  ...
)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{serie}{Column name of serie to plot.}

\item{bind}{Binding between datasets, namely for use of \code{\link{e_brush}}.}

\item{name}{name of the serie.}

\item{legend}{Whether to add serie to legend.}

\item{x_index, y_index}{Indexes of x and y axis.}

\item{coord_system}{Coordinate system to plot against.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Add line serie.
}
\examples{
iris |>
  group_by(Species) |>
  e_charts(Sepal.Length) |>
  e_line(Sepal.Width) |>
  e_tooltip(trigger = "axis")

# timeline
iris |>
  group_by(Species) |>
  e_charts(Sepal.Length, timeline = TRUE) |>
  e_line(Sepal.Width) |>
  e_tooltip(trigger = "axis")
}
\seealso{
\href{https://echarts.apache.org/en/option.html#series-line}{Additional arguments}
}
