% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugins.R
\name{e_cloud}
\alias{e_cloud}
\alias{e_cloud_}
\title{Wordcloud}
\usage{
e_cloud(e, word, freq, color, rm_x = TRUE, rm_y = TRUE, ...)

e_cloud_(e, word, freq, color = NULL, rm_x = TRUE, rm_y = TRUE, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}}.}

\item{word, freq}{Terms and their frequencies.}

\item{color}{Word color.}

\item{rm_x, rm_y}{Whether to remove x and y axis, defaults to \code{TRUE}.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Draw a wordcloud.
}
\examples{
words <- function(n = 5000) {
  a <- do.call(paste0, replicate(5, sample(LETTERS, n, TRUE), FALSE))
  paste0(a, sprintf("\%04d", sample(9999, n, TRUE)), sample(LETTERS, n, TRUE))
}

tf <- data.frame(terms = words(100), 
  freq = rnorm(100, 55, 10)) \%>\% 
  dplyr::arrange(-freq)

tf \%>\% 
  e_color_range(freq, color) \%>\% 
  e_charts() \%>\% 
  e_cloud(terms, freq, color, shape = "circle", sizeRange = c(3, 15))

}
\seealso{
\href{official documentation}{https://github.com/ecomfe/echarts-wordcloud}
}
