% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{e_lm}
\alias{e_lm}
\alias{e_glm}
\alias{e_loess}
\title{Smooth}
\usage{
e_lm(e, formula, name = NULL, legend = TRUE, symbol = "none",
  smooth = TRUE, ...)

e_glm(e, formula, name = NULL, legend = TRUE, symbol = "none",
  smooth = TRUE, ...)

e_loess(e, formula, name = NULL, legend = TRUE, symbol = "none",
  smooth = TRUE, x_index = 0, y_index = 0, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}}.}

\item{formula}{formula to pass to \code{\link{lm}}.}

\item{name}{name of the serie.}

\item{legend}{Whether to add serie to legend.}

\item{symbol}{Symbol to use in \code{\link{e_line}}.}

\item{smooth}{Whether to smooth the line.}

\item{...}{Additional arguments to pass to \code{\link{e_line}}.}

\item{x_index}{Indexes of x and y axis.}

\item{y_index}{Indexes of x and y axis.}
}
\description{
Plot formulas.
}
\examples{
mtcars \%>\% 
  e_charts(mpg) \%>\% 
  e_scatter(qsec, symbol_size = 10) \%>\% 
  e_lm(qsec ~ mpg, name = "y = ax + b")
  
mtcars \%>\% 
  e_charts(disp) \%>\% 
  e_scatter(mpg, qsec) \%>\% 
  e_loess(mpg ~ disp)
  
CO2 \%>\% 
  e_charts(conc) \%>\% 
  e_scatter(uptake, symbol_size = 10) \%>\% 
  e_glm(uptake ~ conc, name = "GLM")

}
