% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lamp-stable-lambda-dist-method.R
\name{dsl}
\alias{dsl}
\alias{dqsl}
\alias{rqsl}
\alias{rsl}
\alias{pqsl}
\alias{psl}
\alias{qqsl}
\alias{qsl}
\alias{kqsl}
\alias{ksl}
\alias{cfqsl}
\alias{cfsl}
\title{Stable lambda distribution}
\usage{
dsl(x, t = 1, nu0 = 0, theta = 1, convo = 1, beta.a = 0, mu = 0, lambda = 4)

dqsl(x, t = 1, nu0 = 0, theta = 1, convo = 1, beta.a = 0, mu = 0)

rqsl(n, t = 1, nu0 = 0, theta = 1, convo = 1, beta.a = 0, mu = 0)

rsl(n, t = 1, nu0 = 0, theta = 1, convo = 1, beta.a = 0, mu = 0, lambda = 4)

pqsl(x, t = 1, nu0 = 0, theta = 1, convo = 1, beta.a = 0, mu = 0)

psl(x, t = 1, nu0 = 0, theta = 1, convo = 1, beta.a = 0, mu = 0, lambda = 4)

qqsl(q, t = 1, nu0 = 0, theta = 1, convo = 1, beta.a = 0, mu = 0)

qsl(q, t = 1, nu0 = 0, theta = 1, convo = 1, beta.a = 0, mu = 0, lambda = 4)

kqsl(t = 1, nu0 = 0, theta = 1, convo = 1, beta.a = 0, mu = 0)

ksl(t = 1, nu0 = 0, theta = 1, convo = 1, beta.a = 0, mu = 0, lambda = 4)

cfqsl(
  s,
  t = 1,
  nu0 = 0,
  theta = 1,
  convo = 1,
  beta.a = 0,
  mu = 0,
  method = "a"
)

cfsl(
  s,
  t = 1,
  nu0 = 0,
  theta = 1,
  convo = 1,
  beta.a = 0,
  mu = 0,
  lambda = 4,
  method = "a"
)
}
\arguments{
\item{x}{numeric, vector of responses.}

\item{t}{numeric, the time parameter, where the variance is t, default is 1.}

\item{nu0}{numeric, the location parameter, default is 0.}

\item{theta}{numeric, the scale parameter, default is 1.}

\item{convo}{numeric, the convolution number, default is 1.}

\item{beta.a}{numeric, the skewness parameter, default is 0. This number is annualized by sqrt(t).}

\item{mu}{numeric, the location parameter, default is 0.}

\item{lambda}{numeric, the shape parameter, default is 4.}

\item{n}{numeric, number of observations.}

\item{q}{numeric, vector of quantiles.}

\item{s}{numeric, vector of responses for characteristic function.}

\item{method}{character, method of characteristic function (CF) calculation. Default is "a".
Method a uses cfstdlap x dstablecnt.
Method b uses dstdlap x cfstablecnt.
Method c uses direct integration on PDF up to 50 stdev.
They should yield the same result.}
}
\value{
numeric, standard convention is followed:
        d* returns the density,
        p* returns the distribution function,
        q* returns the quantile function, and
        r* generates random deviates.
        The following are our extensions:
        k* returns the first 4 cumulants, skewness, and kurtosis,
        cf* returns the characteristic function.
}
\description{
Implements the stable lambda distribution (SLD) and the quartic stable lambda distribution (QSLD).
Be aware of the performance concerns:
(a) The cumulative density function is implemented by direct integration over the density.
(b) The quantile function is implemented by root finding on cumulative density function.
}
\section{Details}{

  The stable lambda distribution is the stationary distribution for financial asset returns.
  It is a product of the stable count distribution and the Lihn-Laplace process.
  The density function is defined as \deqn{
    P_{\Lambda}^{\left(m\right)}\left(x;t,\nu_{0},\theta,\beta_{a},\mu\right)
    \equiv\int_{\nu_{0}}^{\infty} \frac{1}{\nu}\,
    f_{\mathit{L}}^{\left(m\right)}\left(\frac{x-\mu}{\nu};t,\beta_{a}\sqrt{t}\right)\,
    \mathit{N}_\alpha\left(\nu;\nu_{0},\theta\right)d\nu
  }{
    P_\Lambda^(m) (x;t,\nu_0,\theta,\beta_a,\mu)
    = integrate_\nu_0^\infty 1/\nu
    f_L^(m)((x-\mu)/\nu; t,\beta_a sqrt(t))
    N_\alpha(\nu; \nu_0,\theta) d\nu
  }
  where
  \eqn{f_L^{(m)}(.)} is the Lihn-Laplace distribution and
  \eqn{N_\alpha(.)} is the quartic stable count distribution.
  \eqn{t} is the time or sampling period,
  \eqn{\alpha} is the stability index which is \eqn{2/\lambda},
  \eqn{\nu_0} is the floor volatility parameter,
  \eqn{\theta} is the volatility scale parameter,
  \eqn{\beta_a} is the annualized asymmetric parameter,
  \eqn{\mu} is the location parameter.
  \cr
  The quartic stable lambda distribution (QSLD) is a specialized distribution with \eqn{\lambda=4} aka \eqn{\alpha=0.5}.
  The PDF integrand has closed form, and all the moments have closed forms.
  Many financial asset returns can be fitted by QSLD precisely up to 4 standard deviations.
}

\examples{
  # generate the quartic pdf for SPX 1-day distribution
  x <- c(-0.1, 0.1, by=0.001)
  pdf <- dqsl(x, t=1/250, nu0=6.92/100, theta=1.17/100, convo=2, beta=-1.31)

}
\references{
For more detail, see Section 8.2 of
  Stephen Lihn (2017).
  \emph{A Theory of Asset Return and Volatility
  under Stable Law and Stable Lambda Distribution}.
  SSRN: 3046732, \url{https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3046732}.
}
\seealso{
\code{\link{dstablecnt}} for \eqn{N_\alpha(.)},
  and \code{\link{dstdlap}} for \eqn{f_L^{(m)}(.)}.
}
\author{
Stephen H-T. Lihn
}
\keyword{stable-Lambda}
