% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lamp-lihnlap-distribution-method.R
\name{rlihnlap}
\alias{rlihnlap}
\alias{dlihnlap}
\alias{cflihnlap}
\alias{klihnlap}
\alias{dlihnlap_poly}
\title{Lihn-Laplace process and distribution}
\usage{
rlihnlap(n, t = 1, convo = 1, beta = 0, mu = 0)

dlihnlap(x, t = 1, convo = 1, beta = 0, mu = 0)

cflihnlap(s, t = 1, convo = 1, beta = 0, mu = 0)

klihnlap(t = 1, convo = 1, beta = 0, mu = 0)

dlihnlap_poly(x, t = 1, convo = 1, beta = 0, mu = 0)
}
\arguments{
\item{n}{numeric, number of observations.}

\item{t}{numeric, the time parameter, of which the variance is t.}

\item{convo}{numeric, the convolution number, default is 1, which is without convolution.}

\item{beta}{numeric, skewness parameter according to skewed lambda distribution, default is 0.}

\item{mu}{numeric, location parameter, default is 0.}

\item{x}{numeric, vector of responses.}

\item{s}{numeric, vector of responses for characteristic function.}
}
\value{
numeric, standard convention is followed: 
        d* returns the density, 
        p* returns the distribution function, 
        q* returns the quantile function, and 
        r* generates random deviates.
        The following are our extensions:
        k* returns the first 4 cumulants, skewness, and kurtosis,
        cf* returns the characteristic function.
}
\description{
Implements some aspects of Lihn-Laplace process
}
\author{
Stephen H-T. Lihn
}
\keyword{Lihn-Laplace}
