% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecop-term-plot-3x3-method.R
\docType{data}
\name{ecop.term_plot_3x3}
\alias{ecop.term_idx_range}
\alias{ecop.term_plot_3x3}
\alias{ecop.term_realized_days}
\alias{ecop.term_target_days_default}
\title{Produce 3x3 plot of volatility smiles for a date}
\format{An object of class \code{numeric} of length 8.}
\usage{
ecop.term_plot_3x3(term_data, date_str, trim_points = 151,
  target_days = NULL, add.first.day = TRUE, show.put.bid = FALSE)

ecop.term_target_days_default

ecop.term_realized_days(target_days, days)

ecop.term_idx_range(realized_days, days)
}
\arguments{
\item{term_data}{term structure data for one date, produced from \code{ecop.term_master_calculator}}

\item{date_str}{character in the form of YYYY-MM-DD}

\item{trim_points}{integer, specifying number of data points to present in the plots}

\item{target_days}{list of ceiling days for the plot}

\item{add.first.day}{logic, whether to add the first expiration date to \code{target_days}.
Default is \code{TRUE}.}

\item{show.put.bid}{logic, show bid smile for put option. Default is \code{FALSE}.}

\item{days}{list of days to expiration from market data}

\item{realized_days}{list of days realized for the plot}
}
\value{
The 3x3 plot
}
\description{
This utlity produces 3x3 plot of volatility smiles for a date. It is used for the term structure paper.
}
\keyword{datasets}
\keyword{structure}
\keyword{term}

