% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecld.quartic_Qp_atm_attr.R
\name{ecld.quartic_Qp_atm_attr}
\alias{ecld.quartic_Qp_atm_attr}
\alias{ecld.quartic_model_sample}
\alias{ecld.quartic_model_sample_attr}
\title{Calculate ATM attributes from key quartic parameters}
\usage{
ecld.quartic_Qp_atm_attr(df)

ecld.quartic_model_sample(dt, ttm, skew_adjusted = TRUE)

ecld.quartic_model_sample_attr(dt, ttm, target_file, skew_adjusted = TRUE)
}
\arguments{
\item{df}{data.frame}

\item{dt}{character, one of three sample dates used in the quartic model paper (YYYY-MM-DD)}

\item{ttm}{numeric, list of time to expiration (T=1 for one year)}

\item{skew_adjusted}{logical, if true, use skew adjusted T=0 intercep,
else use the tercep from linear fit. Default is \code{TRUE}.}

\item{target_file}{character, file location to cache the attribute data (to avoid lengthy repetitions)}
}
\value{
data.frame
}
\description{
This utility takes a data frame of key quartic parameters, and generates several key ATM attributes.
Input fields are: ttm - time to expiration, sigma - term structure of sigma,
epsilon_ratio - term structure of epsilon/sigma, mu_plus_ratio - term structure of (mu_p-mu_D)/stdev.
The output fields are: atm_ki, atm_kew, atm_vol, rho, and rho_ratio - rho/stdev.
}
\examples{
ttm <- seq(sqrt(90), sqrt(365), length.out=3)^2 / 365
epsr = 0.014 + 0*ttm
mupr <- -(ecld.quartic_SN0_max_RNV() - 0.2*sqrt(ttm))
\dontrun{
    df <- data.frame(ttm=ttm, sigma=0.2*sqrt(ttm/120), mu_plus_ratio=mupr, epsilon_ratio=epsr)
    ecld.quartic_Qp_atm_attr(df)
}
}
\author{
Stephen H-T. Lihn
}
\keyword{quartic}

