% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ebirdst_predictors}
\alias{ebirdst_predictors}
\title{eBird Status and Trends predictors}
\format{
A data frame with 74 rows and 5 columns:
\describe{
\item{predictor}{Predictor variable name.}
\item{predictor_label}{Descriptive labels for predictors for plotting and
translating the cryptic variables names (e.g. \code{umd_fs_c1} is
Evergreen Needleleaf Forest.}
\item{lc_class}{For the land and water cover FRAGSTATS variables, this
gives the associated landcover class. It can be used for grouping
and summarizing the four FRAGSTATS metrics to the level of the
landcover class.}
\item{lc_class_label}{Similar to \code{predictor_label}; however, this variable
gives the FRAGSTATS metrics a single name for the landcover
class.}
}
}
\usage{
ebirdst_predictors
}
\description{
A data frame of the predictors used in the eBird Status and Trends models.
These include effort variables (e.g. distance traveled, number of observers,
etc.) in addition to land and water cover variables. These landcover
variables are derived from the MODIS MCD12Q1 500 m landcover product, and for
each land cover class two FRAGSTATS metrics are calculated within a 1.5 km
buffer around each checklist: \% landcover (PLAND) and edge density (ED).
}
\keyword{datasets}
