% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode2NA.R
\name{recode2NA}
\alias{recode2NA}
\title{Recode values to \code{NA}.}
\usage{
recode2NA(GADSdat, recodeVars = namesGADS(GADSdat), value = "")
}
\arguments{
\item{GADSdat}{A \code{GADSdat} object.}

\item{recodeVars}{Character vector of variable names which should be recoded.}

\item{value}{Which values should be recoded to \code{NA}?}
}
\value{
Returns the recoded \code{GADSdat}.
}
\description{
Recode multiple values in multiple variables in a \code{GADSdat} to \code{NA}.
}
\details{
If there are value labels given to the specified value, a warning is issued. Number of recodes per variable are reported.

If a data set is imported from \code{.sav}, character variables frequently contain empty strings. Especially if parts of the
data are written to \code{.xlsx}, this can cause problems (e.g. as look up tables from \code{\link{createLookup}}),
as most function which write to \code{.xlsx} convert empty strings to \code{NAs}. \code{recodeString2NA} can be
used to recode all empty strings to \code{NA} beforehand.
}
\examples{
# create example GADS
dat <- data.frame(ID = 1:4, var1 = c("", "Eng", "Aus", "Aus2"),
                  var2 = c("", "French", "Ger", "Ita"),
                  stringsAsFactors = FALSE)
gads <- import_DF(dat)

# recode empty strings
gads2 <- recode2NA(gads)

# recode numeric value
gads3 <- recode2NA(gads, recodeVars = "ID", value = 1:3)


}
