% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changeVarNames.R
\name{changeVarNames}
\alias{changeVarNames}
\title{Change Variable Names.}
\usage{
changeVarNames(GADSdat, oldNames, newNames, checkVarNames = TRUE)
}
\arguments{
\item{GADSdat}{\code{GADSdat} object imported via \code{eatGADS}.}

\item{oldNames}{Vector containing the old variable names.}

\item{newNames}{Vector containing the new variable names, in identical order as \code{oldNames}.}

\item{checkVarNames}{Logical. Should new variable names be checked by \code{\link{checkVarNames}}?}
}
\value{
Returns the \code{GADSdat} object with changed variable names.
}
\description{
Change variable names of a \code{GADSdat} or \code{all_GADSdat} object.
}
\details{
Applied to a \code{GADSdat} or \code{all_GADSdat} object, this function is a wrapper of \code{\link{getChangeMeta}} and
\code{\link{applyChangeMeta}}
}
\examples{
# Change multiple variable name
pisa2 <- changeVarNames(pisa, oldNames = c("idstud", "idschool"),
                        newNames = c("IDstud", "IDschool"))

}
