% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tonum.R
\name{tonum}
\alias{tonum}
\title{Convert to Number}
\usage{
tonum(x, preprocessed.values = NULL, nastrings = easyr::nastrings,
  ifna = c("return-unchanged", "error", "warning", "return-na"),
  verbose = TRUE, nazero = FALSE, checkdate = TRUE,
  remove.chars = FALSE, do.logical = TRUE, do.try.integer = TRUE)
}
\arguments{
\item{x}{Vector to convert.}

\item{preprocessed.values}{Strings need to have NAs set, lowercase and be trimmed before they can be checked. To avoid doing this multiple times, you can pass these processed values to the function.}

\item{nastrings}{Vector of characters to be considered NAs. todate will treat these like NAs. Defaults to the easyr::nastrings list.}

\item{ifna}{Action to take if NAs are created. 'return-unchanged'  returns the sent vector unchanged; 'warning' results in a warning and returns the converted vector with new NAs; 'error' results in an error; return-na returns data with new NAs and prints via cat if verbose.}

\item{verbose}{Choose to view messaging.}

\item{nazero}{(Optional) Convert NAs to 0. Defaults to TRUE, if FALSE NAs will stay NA.}

\item{checkdate}{Check if the column is a date first. If this has already been done, set this to FALSE so it doesn't run again.}

\item{remove.chars}{Remove characters for aggressive conversion to numbers.}

\item{do.logical}{Check for logical-form vectors.}

\item{do.try.integer}{Return an integer if possible. Integers are a more compact data type and should be used whenever possible.}
}
\value{
Converted vector.
}
\description{
Flexible number conversion for converting strings to numbers. Handles $ , ' and spaces.
Author: Bryce Chamberlain. Tech review: Dominic Dillingham.
}
\examples{
tonum( c('123','$50.02','30\%','(300.01)',NA,'-','') )
tonum( c('123','$50.02','30\%','(300.01)',NA,'-',''), nazero = FALSE )
}
