% Generated by roxygen2 (4.0.1): do not edit by hand
\name{getEasingData}
\alias{getEasingData}
\title{Get credit easing data.}
\usage{
getEasingData(id = NA, startDate = "012007", endDate = "122100")
}
\arguments{
\item{id}{the query type identifier code as specified by the FRB data site, default NA}

\item{startDate}{the desired start month and year number in MMYYYY format, default 012007}

\item{endDate}{the desired end month and year number in MMYYYY format, default 122100 for all available data}
}
\value{
A list of class \code{easing} containing query items and \code{xts} result.

List of class type \code{easing} containing \code{xts} time history object \code{df}, query start date \code{startDate}, query stop date \code{stopDate}, plot colors array \code{colors}, plot main title \code{main}, and plot y-axis label \code{ylab}.
}
\description{
Downloads Cleveland FRB credit easing policy tool data.
}
\details{
Forms a query using the given \code{id} and submits the query to the data site, thereby downloading the requested data in CSV format.  Transforms the CSV into a data frame, transforms the character date into \code{Date} objects, and then an \code{xts} object.
}
\note{
Meant for internal use by the other, more specific, query functions.
}
\examples{
\dontrun{
getEasingData(id=1)
}
}
\references{
\url{http://www.clevelandfed.org/research/data/credit_easing/index.cfm}
}
\seealso{
getEasingSummary getEasingDetails getEasingLending getEasingCreditDepository getEasingCreditExtensions getEasingProvidingLiquidity getEasingMaidenLane getEasingTraditionalHoldings  getEasingAgencyDebt getEasingLongTermPurchases
}

