# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title
#' time_mat
#'
#' @description
#' Matrix to multiply by astrological.  Code adapted from ETERNA.
#'
#' @param time the times to calculate astrological parameters
#'
#' @return matrix of times
#'
#' @author Jonathan Kennel, \email{jkennel@uoguelph.ca}
#'
#' @references Wenzel, H.-G. (1996): The nanogal software: Earth tide data
#' processing package ETERNA 3.3. Bulletin d'Informations
#' Marees Terrestres vol. 124, 9425-9439, Bruxelles 1996.
#'
#'
time_mat <- function(time) {
    .Call(`_earthtide_time_mat`, time)
}

#' @title
#' time_der_mat
#'
#' @description
#' Matrix to multiply by astrological.  Code adapted from ETERNA.
#'
#' @param time the times to calculate the derivatives of the astrological parameters
#'
#' @return matrix of time derivatives
#'
#' @author Jonathan Kennel, \email{jkennel@uoguelph.ca}
#'
#' @references Wenzel, H.-G. (1996): The nanogal software: Earth tide data
#' processing package ETERNA 3.3. Bulletin d'Informations
#' Marees Terrestres vol. 124, 9425-9439, Bruxelles 1996.
#'
#'
time_der_mat <- function(time) {
    .Call(`_earthtide_time_der_mat`, time)
}

#' @title
#' astro
#'
#' @description
#' Calculate astronomical parameters.  Code adapted from ETERNA.
#'
#' @param t_astro astronomical time
#' @param simon coefficient matrix
#' @param longitude the longitude
#' @param hours hour or measurement
#' @param ddt time in ddt
#'
#' @return astonomical parameters
#'
#' @author Jonathan Kennel, \email{jkennel@uoguelph.ca}
#'
#' @references Wenzel, H.-G. (1996): The nanogal software: Earth tide data
#' processing package ETERNA 3.3. Bulletin d'Informations
#' Marees Terrestres vol. 124, 9425-9439, Bruxelles 1996.
#'
#'
astro <- function(t_astro, simon, longitude, hours, ddt) {
    .Call(`_earthtide_astro`, t_astro, simon, longitude, hours, ddt)
}

#' @title
#' astro_der
#'
#' @description
#' Calculate derivatives of astronomical parameters.  Code adapted from ETERNA.
#'
#' @param t_astro astronomical time
#' @param simon coefficient matrix
#'
#' @return derivative astonomical parameters
#'
#' @author Jonathan Kennel, \email{jkennel@uoguelph.ca}
#'
#' @references Wenzel, H.-G. (1996): The nanogal software: Earth tide data
#' processing package ETERNA 3.3. Bulletin d'Informations
#' Marees Terrestres vol. 124, 9425-9439, Bruxelles 1996.
#'
#'
astro_der <- function(t_astro, simon) {
    .Call(`_earthtide_astro_der`, t_astro, simon)
}

#' @title
#' legendre_bh
#'
#' @description
#' legendre function
#'
#' @param l maximum degree
#' @param m the m value
#' @param x the x value
#' @param csphase the csphase value
#'
#' @return legendre scale
#'
#'
#'
legendre_bh <- function(l, m, x, csphase = -1L) {
    .Call(`_earthtide_legendre_bh`, l, m, x, csphase)
}

#' @title
#' legendre_deriv_bh
#'
#' @description
#' Scaling for legendre function
#'
#' @param l maximum degree
#' @param m the x value
#' @param x the x value
#'
#' @return legendre scale
#'
#'
#'
legendre_deriv_bh <- function(l, m, x) {
    .Call(`_earthtide_legendre_deriv_bh`, l, m, x)
}

#' @title
#' scale_legendre_bh
#'
#' @description
#' Scaling for legendre function
#'
#' @param l maximum degree
#' @param m the x value
#'
#' @return legendre scale
#'
#'
#'
scale_legendre_bh <- function(l, m) {
    .Call(`_earthtide_scale_legendre_bh`, l, m)
}

#' @title
#' legendre
#'
#' @description
#' Calculate legendre
#'
#' @param l_max maximum degree
#' @param x the x value
#'
#' @return legendre polynomials
#'
#'
#'
legendre <- function(l_max, x) {
    .Call(`_earthtide_legendre`, l_max, x)
}

#' @title
#' et_analyze
#'
#' @description
#' Calculate tidal potential for a single time and multiple waves.  Code adapted from ETERNA.
#'
#' @param astro vector astronomical parameters
#' @param astro_der vector derivative of astronomical parameters
#' @param k_mat matrix tidal catalog values
#' @param pk vector of phases for each group
#' @param body vector of body tide for each group
#' @param body_inds indices of body max for each group
#' @param delta vector body
#' @param deltar double gravimentric factor
#' @param x0 vector tidal catalog values
#' @param y0 vector tidal catalog values
#' @param x1 vector tidal catalog values
#' @param y1 vector tidal catalog values
#' @param x2 vector tidal catalog values
#' @param y2 vector tidal catalog values
#' @param j2000 double Julian date
#' @param o1 double frequency
#' @param resonance double frequency
#' @param max_amp int index of the wave with maximum amplitude in wave group
#' @param update_coef double constant for phase updating
#'
#' @return synthetic gravity
#'
#' @author Jonathan Kennel, \email{jkennel@uoguelph.ca}
#' 
#' @references Wenzel, H.-G. (1996): The nanogal software: Earth tide data
#' processing package ETERNA 3.3. Bulletin d'Informations
#' Marees Terrestres vol. 124, 9425-9439, Bruxelles 1996.
#' 
#'
et_analyze <- function(astro, astro_der, k_mat, pk, body, body_inds, delta, deltar, x0, y0, x1, y1, x2, y2, j2000, o1, resonance, max_amp, update_coef) {
    .Call(`_earthtide_et_analyze`, astro, astro_der, k_mat, pk, body, body_inds, delta, deltar, x0, y0, x1, y1, x2, y2, j2000, o1, resonance, max_amp, update_coef)
}

#' @title
#' et_predict
#'
#' @description
#' Calculate tidal potential for a single time and multiple waves.  Code adapted from ETERNA.
#'
#' @param astro vector astronomical parameters
#' @param astro_der vector derivative of astronomical parameters
#' @param k_mat matrix tidal catalog values
#' @param pk vector of phases for each group
#' @param body vector of body tide for each group
#' @param body_inds indices of body max for each group
#' @param delta vector body
#' @param deltar double gravimentric factor
#' @param x0 vector tidal catalog values
#' @param y0 vector tidal catalog values
#' @param x1 vector tidal catalog values
#' @param y1 vector tidal catalog values
#' @param x2 vector tidal catalog values
#' @param y2 vector tidal catalog values
#' @param j2000 double Julian date
#' @param o1 double frequency
#' @param resonance double frequency
#' @param max_amp int index of the wave with maximum amplitude in wave group
#' @param update_coef double constant for phase updating
#'
#' @return synthetic gravity
#'
#' @author Jonathan Kennel, \email{jkennel@uoguelph.ca}
#' 
#' @references Wenzel, H.-G. (1996): The nanogal software: Earth tide data
#' processing package ETERNA 3.3. Bulletin d'Informations
#' Marees Terrestres vol. 124, 9425-9439, Bruxelles 1996.
#' 
#'
et_predict <- function(astro, astro_der, k_mat, pk, body, body_inds, delta, deltar, x0, y0, x1, y1, x2, y2, j2000, o1, resonance, max_amp, update_coef) {
    .Call(`_earthtide_et_predict`, astro, astro_der, k_mat, pk, body, body_inds, delta, deltar, x0, y0, x1, y1, x2, y2, j2000, o1, resonance, max_amp, update_coef)
}

#' @title
#' et_calculate
#'
#' @description
#' Parallel calculation of tidal potential for a single time and multiple waves.  Code adapted from ETERNA.
#'
#' @param astro matrix astronomical parameters
#' @param astro_der matrix derivative of astronomical parameters
#' @param k_mat matrix tidal catalog values
#' @param phases vector phases
#' @param delta vector body
#' @param deltar double gravimentric factor
#' @param c0 vector tidal catalog values
#' @param s0 vector tidal catalog values
#' @param c1 vector tidal catalog values
#' @param s1 vector tidal catalog values
#' @param c2 vector tidal catalog values
#' @param s2 vector tidal catalog values
#' @param dgk vector geodetic coefficients
#' @param jcof vector wave index
#' @param j2000 double Julian date
#' @param o1 double frequency
#' @param resonance double frequency
#' @param index vector wave group index
#' @param astro_update how often to recalculate astronomical parameters
#' @param update_coef time for approx
#' @param predict predict or analyze
#'
#' @return synthetic gravity
#'
#' @author Jonathan Kennel, \email{jkennel@uoguelph.ca}
#' 
#' @references Wenzel, H.-G. (1996): The nanogal software: Earth tide data
#' processing package ETERNA 3.3. Bulletin d'Informations
#' Marees Terrestres vol. 124, 9425-9439, Bruxelles 1996.
#' 
#'
et_calculate <- function(astro, astro_der, k_mat, phases, delta, deltar, c0, s0, c1, s1, c2, s2, dgk, jcof, j2000, o1, resonance, index, astro_update, update_coef, predict) {
    .Call(`_earthtide_et_calculate`, astro, astro_der, k_mat, phases, delta, deltar, c0, s0, c1, s1, c2, s2, dgk, jcof, j2000, o1, resonance, index, astro_update, update_coef, predict)
}

