% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getters.R
\name{get_priors}
\alias{get_priors}
\alias{get_priors.dynamiteformula}
\alias{get_priors.dynamitefit}
\title{Get Prior Definitions of a Dynamite Model}
\usage{
get_priors(x, ...)

\method{get_priors}{dynamiteformula}(x, data, time, group = NULL, ...)

\method{get_priors}{dynamitefit}(x, ...)
}
\arguments{
\item{x}{[\code{dynamiteformula} or \code{dynamitefit}]\cr The model formula or an
existing \code{dynamitefit} object. See \code{\link[=dynamiteformula]{dynamiteformula()}} and \code{\link[=dynamite]{dynamite()}}.}

\item{...}{Ignored.}

\item{data}{[\code{data.frame}, \code{tibble::tibble}, or \code{data.table::data.table}]\cr
The data that contains the variables in the model in long format.
Supported column types are \code{integer}, \code{logical}, \code{double}, and
\code{factor}. Columns of type \code{character} will be converted to factors.
Unused factor levels will be dropped. The \code{data} can contain missing
values which will simply be ignored in the estimation in a case-wise
fashion (per time-point and per channel). Input \code{data} is converted to
channel specific matrix representations via \code{\link[stats:model.matrix]{stats::model.matrix.lm()}}.}

\item{time}{[\code{character(1)}]\cr A column name of \code{data} that denotes the
time index of observations. If this variable is a factor, the integer
representation of its levels are used internally for defining the time
indexing.}

\item{group}{[\code{character(1)}]\cr A column name of \code{data} that denotes the
unique groups or \code{NULL} corresponding to a scenario without any groups.
If \code{group} is \code{NULL}, a new column \code{.group} is created with constant
value \code{1L} is created indicating that all observations belong to the same
group. In case of name conflicts with \code{data}, see the \code{group_var} element
of the return object to get the column name of the new variable.}
}
\value{
A \code{data.frame} containing the prior definitions.
}
\description{
Extracts the priors used in the dynamite model as a data frame. You
can then alter the priors by changing the contents of the \code{prior} column and
supplying this data frame to \code{dynamite} function using the argument
\code{priors}. See vignettes for details.
}
\note{
Only the \code{prior} column of the output should be altered when defining
the user-defined priors for the \code{dynamite}.
}
\examples{
data.table::setDTthreads(1) # For CRAN
d <- data.frame(y = rnorm(10), x = 1:10, time = 1:10, id = 1)
get_priors(obs(y ~ x, family = "gaussian"),
  data = d, time = "time", group = "id"
)

}
\seealso{
Model fitting
\code{\link{dynamite}()},
\code{\link{update.dynamitefit}()}
}
\concept{fitting}
