% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.ddhazard}
\alias{predict.ddhazard}
\title{Predict Method for ddhazard Object}
\usage{
\method{predict}{ddhazard}(object, new_data, type = c("response", "term"),
  tstart = "start", tstop = "stop", use_parallel = F, sds = F,
  max_threads = getOption("ddhazard_max_threads"), ...)
}
\arguments{
\item{object}{result of a \code{\link{ddhazard}} call.}

\item{new_data}{new data to base predictions on.}

\item{type}{either \code{"response"} for predicted probability of death or \code{"term"} for predicted terms in the linear predictor.}

\item{tstart}{name of the start time column in \code{new_data}. It must be on the same time scale as the tstart used in the \code{\link[survival]{Surv}(tstart, tstop, event)} in the \code{formula} passed to \code{\link{ddhazard}}.}

\item{tstop}{same as \code{tstart} for the stop argument.}

\item{use_parallel}{\code{TRUE} if computation for \code{type = "response"} should be computed in parallel with the \code{\link{mcmapply}}. Notice the limitation in the help page of \code{\link{mcmapply}}.}

\item{sds}{\code{TRUE} if point wise standard deviation should be computed. Convenient if you use functions like \code{\link[splines]{ns}} and you only want one term per term in the right hand site of the \code{formula} used in \code{\link{ddhazard}}.}

\item{max_threads}{maximum number of threads to use. -1 if it should be determined by a call to \code{\link[parallel]{detectCores}}.}

\item{...}{not used.}
}
\description{
Predict method for \code{\link{ddhazard}}.
}
\section{Term}{

The result with \code{type = "term"} is a list with the following elements
\describe{
\item{\code{terms}}{is a 3D array. The first dimension is the number of bins, the second dimension is rows in \code{new_data} and the last dimension is the state space terms.}
\item{\code{sds}}{similar to \code{terms} for the point wise confidence intervals using the smoothed co-variance matrices.}
\item{\code{fixed_terms}}{vector of the fixed effect terms for each observation.}
}
}

\section{Response}{

The result with \code{type = "response"} is a list with the elements below. The function check if there are columns in \code{new_data} which names match \code{tstart} and \code{tstop}. If not, then each row in new data will get a predicted probability of dying in every bin.
\describe{
\item{\code{fits}}{fitted probability of dying.}
\item{\code{istart}}{vector with the index of the first bin the elements in \code{fits} is in.}
\item{\code{istop}}{vector with the index of the last bin the elements in \code{fits} is in.}
}
}

\examples{
fit <- ddhazard(
 Surv(time, status == 2) ~ log(bili), pbc, id = pbc$id, max_T = 3600,
 Q_0 = diag(1, 2), Q = diag(1e-4, 2), by = 50,
 control = list(method = "GMA"))
predict(fit, type = "response", new_data =
 data.frame(time = 0, status = 2, bili = 3))
predict(fit, type = "term", new_data =
 data.frame(time = 0, status = 2, bili = 3))

}
