% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamac.R
\name{summary.dynardl}
\alias{summary.dynardl}
\title{Enable summary calls to dynardl model objects.}
\usage{
\method{summary}{dynardl}(object, ...)
}
\arguments{
\item{object}{a \code{dynardl} model}

\item{...}{additional arguments in the generic summary call}
}
\value{
A summary of the fitted ARDL model.
}
\description{
Enable summary calls to dynardl model objects.
}
\details{
\code{dynardl}, by default, stores regression results in \code{foo$model}. This calls those results 
directly with \code{summary}.
}
\examples{
# Using the ineq data from dynamac
ardl.model <- dynardl(concern ~ incshare10 + urate, data = ineq, 
       lags = list("concern" = 1, "incshare10" = 1),
       diffs = c("incshare10", "urate"), 
       lagdiffs = list("concern" = 1),
       ec = TRUE, simulate = FALSE)
summary(ardl.model)
}
\author{
Soren Jordan and Andrew Q. Philips
}
\keyword{utilities}
