/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui.about;

import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.jfree.base.Library;
import org.jfree.ui.about.LibraryTableModel;
import org.jfree.ui.about.ProjectInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryPanel
extends JPanel {
    private static final long serialVersionUID = 1879906415120237255L;
    private JTable table;
    private LibraryTableModel model;

    public LibraryPanel(List libraries) {
        this.setLayout(new BorderLayout());
        this.model = new LibraryTableModel(libraries);
        this.table = new JTable(this.model);
        this.add(new JScrollPane(this.table));
    }

    public LibraryPanel(ProjectInfo projectInfo) {
        this(LibraryPanel.getLibraries(projectInfo));
    }

    private static List getLibraries(ProjectInfo info) {
        if (info == null) {
            return new ArrayList();
        }
        ArrayList<Library> libs = new ArrayList<Library>();
        LibraryPanel.collectLibraries(info, libs);
        return libs;
    }

    private static void collectLibraries(ProjectInfo info, List<Library> list) {
        Library lib;
        Library[] libs = info.getLibraries();
        int i = 0;
        while (i < libs.length) {
            lib = libs[i];
            if (!list.contains(lib)) {
                list.add(lib);
                if (lib instanceof ProjectInfo) {
                    LibraryPanel.collectLibraries((ProjectInfo)lib, list);
                }
            }
            ++i;
        }
        libs = info.getOptionalLibraries();
        i = 0;
        while (i < libs.length) {
            lib = libs[i];
            if (!list.contains(lib)) {
                list.add(lib);
                if (lib instanceof ProjectInfo) {
                    LibraryPanel.collectLibraries((ProjectInfo)lib, list);
                }
            }
            ++i;
        }
    }

    public LibraryTableModel getModel() {
        return this.model;
    }

    protected JTable getTable() {
        return this.table;
    }
}

