/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.PolarChartPanel;
import org.jfree.chart.plot.PolarPlot;
import org.jfree.chart.renderer.DefaultPolarItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.experimental.data.xy.VectorSeries;
import org.jfree.experimental.data.xy.VectorSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class PolarChartDemo
extends ApplicationFrame {
    private static final long serialVersionUID = 2019237349040333685L;

    public PolarChartDemo(String title) {
        super(title);
        XYDataset dataset = this.createDataset();
        JFreeChart chart = this.createChart(dataset);
        PolarChartPanel chartPanel = new PolarChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setEnforceFileExtensions(false);
        this.setContentPane(chartPanel);
    }

    private XYDataset createDataset() {
        VectorSeries mySerie = new VectorSeries((Comparable)((Object)""));
        mySerie.add(0.0, 0.0, 1.0, 0.0);
        VectorSeriesCollection myData = new VectorSeriesCollection();
        return myData;
    }

    private JFreeChart createChart(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createPolarChart("Polar Chart Demo", dataset, true, true, false);
        PolarPlot plot = (PolarPlot)chart.getPlot();
        DefaultPolarItemRenderer renderer = (DefaultPolarItemRenderer)plot.getRenderer();
        renderer.setSeriesFilled(0, false);
        return chart;
    }

    public static void main(String[] argv) {
        PolarChartDemo demo = new PolarChartDemo("Polar Chart Demo");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

