/*
 * Decompiled with CFR 0.152.
 */
package dyn;

import don.ContinueAnalysee;
import don.DonneeID;
import don.DonneeMoyenne;
import dyn.NuagePoint;
import ihm.Gestionnaire;
import ihm.Habilleur;
import java.util.Vector;
import org.jfree.chart.annotations.XYIDAnnotation;
import org.jfree.chart.annotations.XYLineAnnotation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NuagePointHabille
extends NuagePoint {
    protected boolean m_partiel = false;

    public NuagePointHabille(Gestionnaire gest, Habilleur hab, String titreGraphe, String titreX, String titreY) {
        super(gest, hab, titreGraphe, titreX, titreY);
    }

    @Override
    public void affAnnotation(Vector<DonneeID> liste) {
        this.setCanvas();
        XYPlot plot = (XYPlot)this.m_gestionnaire.getPanel().getChart().getPlot();
        AbstractXYItemRenderer renderer = (AbstractXYItemRenderer)plot.getRenderer();
        if (this.m_gestionnaire.getCanvas() != null) {
            this.m_gestionnaire.getCanvas().clearAnnot();
        }
        renderer.removeAnnotations();
        if (this.m_data.getSeriesCount() != 0) {
            this.trace(renderer, liste);
        }
    }

    private void trace(AbstractXYItemRenderer renderer, Vector<DonneeID> obj) {
        for (DonneeID id : obj) {
            ContinueAnalysee axeX = this.m_gestionnaire.getAxeX();
            ContinueAnalysee axeY = this.m_gestionnaire.getAxeY();
            double x = id.getCoord(axeX);
            double y = id.getCoord(axeY);
            XYIDAnnotation annot = new XYIDAnnotation(id.getAnnotation(), id.getXannot(axeX, axeY), id.getYannot(axeX, axeY), x, y, this.getCouleur(id));
            this.m_habilleur.setFont(annot, id);
            if (id instanceof DonneeMoyenne && this.m_gestionnaire.isAffPartiels(id)) {
                this.tracePartiel(renderer, (DonneeMoyenne)((Object)id));
            }
            annot.setTextAnchor(id.getAnchor());
            if (!this.m_gestionnaire.isAnnotations(id) || this.m_gestionnaire.isFantome(id)) continue;
            renderer.addAnnotation(annot);
            this.m_canvas.addAnnot(annot);
        }
    }

    @Override
    public void renderer() {
        super.renderer();
        XYPlot plot = (XYPlot)this.m_gestionnaire.getPanel().getChart().getPlot();
        AbstractXYItemRenderer renderer = (AbstractXYItemRenderer)plot.getRenderer();
        if (this.m_data.getSeriesCount() > 0 && this.m_partiel) {
            renderer.setSeriesVisible(this.m_data.getSeriesCount() - 1, (Boolean)false);
        }
    }

    private void tracePartiel(AbstractXYItemRenderer renderer, DonneeMoyenne donneeMoyenne) {
        if (donneeMoyenne instanceof DonneeID) {
            DonneeID donnee = (DonneeID)((Object)donneeMoyenne);
            ContinueAnalysee axeX = this.m_gestionnaire.getAxeX();
            ContinueAnalysee axeY = this.m_gestionnaire.getAxeY();
            if (!this.m_gestionnaire.isFantome(donnee)) {
                int i = 0;
                while (i < donneeMoyenne.getNbBranches()) {
                    DonneeID partiel = donneeMoyenne.getBranches().get(i);
                    String texte = String.valueOf(partiel.getAnnotation()) + " (" + partiel.getGr().getAnnotation() + ")";
                    XYIDAnnotation annot = new XYIDAnnotation(texte, partiel.getXannot(axeX, axeY), partiel.getYannot(axeX, axeY), partiel.getCoord(axeX), partiel.getCoord(axeY), this.getCouleur((DonneeID)((Object)donneeMoyenne)));
                    this.m_habilleur.setFont(annot, partiel);
                    annot.setTextAnchor(partiel.getAnchor());
                    if (this.m_gestionnaire.isAnnotations(donnee)) {
                        renderer.addAnnotation(annot);
                        this.m_canvas.addAnnot(annot);
                    }
                    XYLineAnnotation line = new XYLineAnnotation(donnee.getCoord(this.m_gestionnaire.getAxeX()), donnee.getCoord(this.m_gestionnaire.getAxeY()), partiel.getCoord(this.m_gestionnaire.getAxeX()), partiel.getCoord(this.m_gestionnaire.getAxeY()));
                    this.m_canvas.addBranche(line);
                    renderer.addAnnotation(line);
                    ++i;
                }
            }
        }
    }
}

