/*
 * Decompiled with CFR 0.152.
 */
package don;

import don.AxePartiel;
import don.Continue;
import don.ContinueAnalysee;
import don.ContinueArtificiellePourCont;
import don.ContinueArtificiellePourMod;
import don.ContinueMoyenne;
import don.Dimension;
import don.DonneeID;
import don.Groupe;
import don.Individu;
import don.IndividuMoyen;
import don.Modalite;
import don.ModaliteMoyenne;
import don.Nominale;
import don.Verifiable;
import exceptions.ExceptionIntegrite;
import ihm.FenetreErreur;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DonneeParse
implements Serializable,
Verifiable {
    private static final long serialVersionUID = -3082877286069225411L;
    private String[] m_colName;
    private Vector<Dimension> m_axes;
    private Vector<Nominale> m_nominales;
    private Vector<IndividuMoyen> m_individusMoyen;
    private Vector<ContinueMoyenne> m_continuesMoyennes;
    private Vector<AxePartiel> m_axesPartiels;
    private Vector<Groupe> m_groupes;
    private double[] m_inerties;
    private TypeAnalyse m_type;

    public DonneeParse(String[] nomsColonnes, int axe, TypeAnalyse type) {
        this.m_colName = nomsColonnes;
        this.setNbAxe(axe);
        this.m_type = type;
        this.m_nominales = new Vector();
        this.m_individusMoyen = new Vector();
        this.m_continuesMoyennes = new Vector();
        this.m_axesPartiels = new Vector();
        this.m_groupes = new Vector();
        this.m_inerties = new double[axe];
    }

    public DonneeParse(String[] nomsColonnes, int axe) {
        this(nomsColonnes, axe, TypeAnalyse.AUTRE);
    }

    public String[] getColName() {
        return this.m_colName;
    }

    public void setColName(String[] colName) {
        this.m_colName = colName;
    }

    public int getDebutNomsVariables() {
        int deb = this.getNbAxe() * 3;
        return deb += 4;
    }

    public int getNbAxe() {
        return this.m_axes.size();
    }

    public void setNbAxe(int nbAxe) {
        this.m_axes = new Vector();
        int i = 1;
        while (i <= nbAxe) {
            this.m_axes.add(new Dimension(i));
            ++i;
        }
    }

    public Vector<IndividuMoyen> getIndividusMoyens() {
        return this.m_individusMoyen;
    }

    public Vector<ContinueMoyenne> getVariablesMoyennes() {
        return this.m_continuesMoyennes;
    }

    public Vector<AxePartiel> getAxesPartiels() {
        return this.m_axesPartiels;
    }

    public void addIndividuMoyen(IndividuMoyen obj) {
        this.m_individusMoyen.add(obj);
    }

    public void addAxePartiel(AxePartiel obj) {
        this.m_axesPartiels.add(obj);
    }

    public void addContinueMoyenne(ContinueMoyenne obj) {
        this.m_continuesMoyennes.add(obj);
    }

    public void addGroupe(Groupe obj) {
        this.m_groupes.add(obj);
    }

    public void addNominale(Nominale obj) {
        this.m_nominales.add(obj);
    }

    public Vector<Groupe> getGroupes() {
        return this.m_groupes;
    }

    public Groupe getGroupe(int i) throws Exception {
        Groupe g = null;
        if (this.m_groupes == null) {
            throw new Exception("pas de groupes dans le jeu de donn\u00e9es");
        }
        int j = 0;
        while (j < this.m_groupes.size() && g == null) {
            Groupe g2 = this.m_groupes.elementAt(j);
            if (g2.getNum() == i) {
                g = g2;
            }
            ++j;
        }
        if (g == null) {
            g = new Groupe(i);
            this.m_groupes.add(g);
        }
        return g;
    }

    public Vector<Nominale> getNominales() {
        return this.m_nominales;
    }

    public Nominale getNominale(int i) throws Exception {
        if (this.m_nominales == null) {
            throw new Exception("pas de nominales dans le jeu de donn\u00e9es");
        }
        if (i < this.m_nominales.size() && i >= 0) {
            return this.m_nominales.get(i);
        }
        throw new Exception("nominale n\ufffd " + i + " introuvable");
    }

    public Nominale getNominale(String annotation) {
        for (Nominale nom : this.m_nominales) {
            if (!nom.getAnnotation().equals(annotation)) continue;
            return nom;
        }
        return null;
    }

    public double[] getInerties() {
        return this.m_inerties;
    }

    public void setInerties(double[] inerties) {
        this.m_inerties = inerties;
    }

    public Individu getIndividu(String annot) throws Exception {
        Individu ind = null;
        if (this.m_individusMoyen == null) {
            throw new Exception("pas d'individus dans le jeu de donn\u00e9es");
        }
        int i = 0;
        while (i < this.m_individusMoyen.size() && ind == null) {
            ind = this.m_individusMoyen.elementAt(i).getIndividu(annot);
            ++i;
        }
        return ind;
    }

    public double getValeur(Individu ind, ContinueAnalysee c) {
        return c.getValeur(ind);
    }

    public double getValeur(Modalite mod, ContinueArtificiellePourMod c) {
        return c.getValeur(mod);
    }

    public double getValeur(DonneeID id, Continue c) {
        if (id instanceof Individu) {
            return c.getValeur((Individu)id);
        }
        if (id instanceof Modalite && c instanceof ContinueArtificiellePourMod) {
            return ((ContinueArtificiellePourMod)c).getValeur((Modalite)id);
        }
        if (id instanceof Modalite) {
            return c.getValeur((Modalite)id);
        }
        if (id instanceof Groupe) {
            return c.getValeur((Groupe)id);
        }
        if (id instanceof ContinueAnalysee && c instanceof ContinueArtificiellePourCont) {
            return ((ContinueArtificiellePourCont)c).getValeur((ContinueAnalysee)id);
        }
        throw new InvalidParameterException(String.valueOf(id.getClass().getCanonicalName()) + ", " + c.getClass().getCanonicalName());
    }

    public ContinueAnalysee getContinue(String annot) {
        ContinueAnalysee var = null;
        int i = 0;
        while (i < this.m_continuesMoyennes.size() && var == null) {
            var = this.m_continuesMoyennes.elementAt(i).getVariable(annot);
            ++i;
        }
        return var;
    }

    public int getNumVariable(String annot) {
        int i = 0;
        while (i < this.getNbVar()) {
            String tmp = this.getVariablesMoyennes().elementAt(i).getAnnotation();
            if (annot.equals(tmp)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Modalite getModalite(String annot) {
        Modalite mod = null;
        int i = 0;
        while (i < this.m_nominales.size() && mod == null) {
            mod = this.m_nominales.elementAt(i).getModalite(annot);
            ++i;
        }
        return mod;
    }

    public boolean isIndActif() {
        boolean trouve = false;
        int i = 0;
        while (i < this.m_individusMoyen.size() && !trouve) {
            trouve = this.m_individusMoyen.elementAt(i).isActive();
            ++i;
        }
        return trouve;
    }

    public boolean isIndIllus() {
        boolean trouve = false;
        int i = 0;
        while (i < this.m_individusMoyen.size() && !trouve) {
            trouve = !this.m_individusMoyen.elementAt(i).isActive();
            ++i;
        }
        return trouve;
    }

    public boolean isModActif() {
        boolean trouve = false;
        int i = 0;
        while (i < this.m_nominales.size() && !trouve) {
            trouve = this.m_nominales.elementAt(i).isModActif();
            ++i;
        }
        return trouve;
    }

    public boolean isModIllus() {
        boolean trouve = false;
        int i = 0;
        while (i < this.m_nominales.size() && !trouve) {
            trouve = this.m_nominales.elementAt(i).isModIllus();
            ++i;
        }
        return trouve;
    }

    public boolean isGroupeActif() {
        boolean trouve = false;
        int i = 0;
        while (i < this.m_groupes.size() && !trouve) {
            trouve = this.m_groupes.elementAt(i).isActive();
            ++i;
        }
        return trouve;
    }

    public boolean isGroupeIllus() {
        boolean trouve = false;
        int i = 0;
        while (i < this.m_groupes.size() && !trouve) {
            trouve = !this.m_groupes.elementAt(i).isActive();
            ++i;
        }
        return trouve;
    }

    public boolean isVarActifOrtho() {
        boolean trouve = false;
        int i = 0;
        while (i < this.m_continuesMoyennes.size() && !trouve) {
            trouve = this.m_continuesMoyennes.elementAt(i).isActive() && this.m_continuesMoyennes.elementAt(i).isOrthonorme();
            ++i;
        }
        return trouve;
    }

    public boolean isVarIllusOrtho() {
        boolean trouve = false;
        int i = 0;
        while (i < this.m_continuesMoyennes.size() && !trouve) {
            trouve = !this.m_continuesMoyennes.elementAt(i).isActive() && this.m_continuesMoyennes.elementAt(i).isOrthonorme();
            ++i;
        }
        return trouve;
    }

    public boolean isVarActifNonOrtho() {
        boolean trouve = false;
        int i = 0;
        while (i < this.m_continuesMoyennes.size() && !trouve) {
            trouve = this.m_continuesMoyennes.elementAt(i).isActive() && !this.m_continuesMoyennes.elementAt(i).isOrthonorme();
            ++i;
        }
        return trouve;
    }

    public boolean isVarIllusNonOrtho() {
        boolean trouve = false;
        int i = 0;
        while (i < this.m_continuesMoyennes.size() && !trouve) {
            trouve = !this.m_continuesMoyennes.elementAt(i).isActive() && !this.m_continuesMoyennes.elementAt(i).isOrthonorme();
            ++i;
        }
        return trouve;
    }

    public boolean isVar() {
        return this.m_continuesMoyennes.size() > 0;
    }

    public boolean isIndPart() {
        boolean trouve = false;
        int i = 0;
        while (i < this.m_individusMoyen.size() && !trouve) {
            trouve = this.m_individusMoyen.elementAt(i).getNbBranches() > 0;
            ++i;
        }
        return trouve;
    }

    public boolean isVarPart() {
        boolean trouve = false;
        int i = 0;
        while (i < this.m_continuesMoyennes.size() && !trouve) {
            trouve = this.m_continuesMoyennes.elementAt(i).getNbBranches() > 0;
            ++i;
        }
        return trouve;
    }

    public boolean isAxesPart() {
        return this.m_axesPartiels.size() > 0;
    }

    public boolean isRepDataframePossible() {
        return this.getVariablesMoyennes() != null && this.getVariablesMoyennes().size() > 1;
    }

    public int getNbIndividu() {
        int taille = 0;
        for (IndividuMoyen ind : this.m_individusMoyen) {
            taille += ind.getNbBranches() + 1;
        }
        return taille;
    }

    public int getNbVar() {
        return this.m_continuesMoyennes.size();
    }

    @Override
    public void verifierIntegrite() throws ExceptionIntegrite {
        for (Nominale nominale : this.m_nominales) {
            nominale.verifierIntegrite();
        }
        for (Individu individu : this.m_individusMoyen) {
            individu.verifierIntegrite();
        }
        boolean[] blArray = new boolean[this.m_continuesMoyennes.size()];
        int i = 0;
        while (i < blArray.length) {
            blArray[i] = false;
            ++i;
        }
        i = 0;
        while (i < this.m_continuesMoyennes.size()) {
            ContinueMoyenne var;
            block16: {
                var = this.m_continuesMoyennes.get(i);
                try {
                    var.verifierIntegrite();
                }
                catch (ExceptionIntegrite e) {
                    if (e.getMessage().equals("Variable sans num\u00e9ro, impossible d'effectuer des getValeur")) {
                        if (var.getNum() >= 0 && this.getNumVariable(var.getAnnotation()) == 0) break block16;
                        var.setNum(i);
                        try {
                            var.verifierIntegrite();
                        }
                        catch (ExceptionIntegrite exceptionIntegrite) {
                            if (!e.getMessage().equals("Variable sans num\u00e9ro, impossible d'effectuer des getValeur") || var.getNum() != 0) {
                                throw exceptionIntegrite;
                            }
                            break block16;
                        }
                    }
                    throw e;
                }
            }
            if (blArray[var.getNum()]) {
                throw new ExceptionIntegrite("num\ufffdros de variables redondants");
            }
            blArray[var.getNum()] = true;
            ++i;
        }
        for (Groupe gr : this.m_groupes) {
            gr.verifierIntegrite();
            int nbAxesPartiels = 0;
            for (ContinueAnalysee continueAnalysee : this.m_axesPartiels) {
                if (continueAnalysee instanceof AxePartiel) {
                    if (continueAnalysee.getGr().equals(gr)) {
                        ++nbAxesPartiels;
                    }
                    ((AxePartiel)continueAnalysee).verifierIntegrite();
                    continue;
                }
                throw new ExceptionIntegrite("Des continues normales ont \u00e9t\u00e9 rang\u00e9es avec les axes partiels : \n" + continueAnalysee.toString());
            }
            if (nbAxesPartiels <= this.getNbAxe()) continue;
            throw new ExceptionIntegrite("nombre anormal d'axes partiels sur le groupe " + gr.getNum() + " (" + gr.getNum() + ") : " + nbAxesPartiels + " au lieu de max " + this.getNbAxe());
        }
        if (this.getNbAxe() > this.getInerties().length) {
            this.setNbAxe(this.getInerties().length);
        }
    }

    public Vector<DonneeID> toDonneeID() {
        Vector<DonneeID> liste = new Vector<DonneeID>();
        int i = 0;
        while (i < this.getIndividusMoyens().size()) {
            liste.add(this.getIndividusMoyens().get(i));
            ++i;
        }
        i = 0;
        while (i < this.getVariablesMoyennes().size()) {
            liste.add(this.getVariablesMoyennes().get(i));
            ++i;
        }
        i = 0;
        while (i < this.getAxesPartiels().size()) {
            liste.add(this.getAxesPartiels().get(i));
            ++i;
        }
        liste.addAll(this.getModalites());
        i = 0;
        while (i < this.getGroupes().size()) {
            try {
                if (this.getGroupe(i).getNum() != 0) {
                    liste.add(this.getGroupe(i));
                }
            }
            catch (Exception e) {
                new FenetreErreur(e);
            }
            ++i;
        }
        return liste;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        String chaine = "";
        try {
            void var2_13;
            chaine = "Jeu de donn\u00e9es :\n" + this.m_individusMoyen.size() + " individus :\n";
            for (IndividuMoyen individuMoyen : this.m_individusMoyen) {
                chaine = String.valueOf(chaine) + individuMoyen.toString() + "\n";
            }
            chaine = String.valueOf(chaine) + "================\nVariables quantitatives :\n";
            for (ContinueMoyenne continueMoyenne : this.m_continuesMoyennes) {
                chaine = String.valueOf(chaine) + continueMoyenne.toString() + "\n";
            }
            chaine = String.valueOf(chaine) + "================\nVariables qualitatives :\n";
            for (Nominale nominale : this.m_nominales) {
                chaine = String.valueOf(chaine) + nominale.toString() + "\n";
            }
            chaine = String.valueOf(chaine) + "================\nGroupes (" + this.m_groupes.size() + "):\n";
            for (Groupe groupe : this.m_groupes) {
                chaine = String.valueOf(chaine) + groupe.toString() + "\n";
            }
            chaine = String.valueOf(chaine) + "====================\nNombre d'axes : " + this.getNbAxe();
            chaine = String.valueOf(chaine) + "\nliste : ";
            for (Dimension dimension : this.m_axes) {
                chaine = String.valueOf(chaine) + dimension.toString() + " ";
            }
            chaine = String.valueOf(chaine) + "\ninerties :";
            boolean bl = true;
            while (var2_13 <= this.getNbAxe()) {
                chaine = String.valueOf(chaine) + "\naxe " + (int)var2_13 + " : " + this.m_inerties[var2_13 - true] + " %";
                ++var2_13;
            }
            chaine = String.valueOf(chaine) + "====================\nNombre d'axes partiels: " + this.m_axesPartiels.size();
            chaine = String.valueOf(chaine) + "\nliste :";
            for (ContinueAnalysee continueAnalysee : this.m_axesPartiels) {
                chaine = String.valueOf(chaine) + continueAnalysee.toString() + "\n";
            }
        }
        catch (Exception exception) {
            chaine = String.valueOf(chaine) + "\nERREUR :\n" + exception;
        }
        return chaine;
    }

    public static String pourcentage(double d) {
        return String.valueOf(String.format("%1$.5s", d)) + " %";
    }

    public TypeAnalyse getType() {
        return this.m_type;
    }

    public void setType(TypeAnalyse m_type) {
        this.m_type = m_type;
    }

    public Vector<ModaliteMoyenne> getModalites() {
        Vector<ModaliteMoyenne> liste = new Vector<ModaliteMoyenne>();
        int i = 0;
        while (i < this.getNominales().size()) {
            Vector<ModaliteMoyenne> mod = this.getNominales().get(i).getModalites();
            int j = 0;
            while (j < mod.size()) {
                liste.add(mod.get(j));
                ++j;
            }
            ++i;
        }
        return liste;
    }

    public Dimension getAxe(int n) {
        for (Dimension axe : this.m_axes) {
            if (axe.getNum() != n) continue;
            return axe;
        }
        return null;
    }

    public boolean isNominales() {
        return this.getNominales().size() > 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TypeAnalyse {
        PCA,
        MCA,
        MFA,
        CA,
        AFDM,
        DATAFRAME,
        AUTRE;

    }
}

