/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.utils;

import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jvnet.lafwidget.utils.FadeTracker;

public class FadeConfigurationManager {
    private static FadeConfigurationManager instance;
    private Set globalAllowed = new HashSet();
    private Map classAllowed = new HashMap();

    public static synchronized FadeConfigurationManager getInstance() {
        if (instance == null) {
            instance = new FadeConfigurationManager();
        }
        return instance;
    }

    private FadeConfigurationManager() {
    }

    public synchronized void allowFades(FadeTracker.FadeKind fadeKind) {
        this.globalAllowed.add(fadeKind);
    }

    public synchronized void allowFades(FadeTracker.FadeKind fadeKind, Class clazz) {
        HashSet<Class> existing = (HashSet<Class>)this.classAllowed.get(fadeKind);
        if (existing == null) {
            existing = new HashSet<Class>();
            this.classAllowed.put(fadeKind, existing);
        }
        existing.add(clazz);
    }

    public synchronized void allowFades(FadeTracker.FadeKind fadeKind, Class[] clazz) {
        for (int i = 0; i < clazz.length; ++i) {
            this.allowFades(fadeKind, clazz[i]);
        }
    }

    public synchronized void disallowFades(FadeTracker.FadeKind fadeKind) {
        this.globalAllowed.remove(fadeKind);
    }

    public synchronized void disallowFades(FadeTracker.FadeKind fadeKind, Class clazz) {
        Set existing = (Set)this.classAllowed.get(fadeKind);
        if (existing == null) {
            return;
        }
        existing.remove(clazz);
        if (existing.size() == 0) {
            this.classAllowed.remove(fadeKind);
        }
    }

    public synchronized void disallowFades(FadeTracker.FadeKind fadeKind, Class[] clazz) {
        for (int i = 0; i < clazz.length; ++i) {
            this.disallowFades(fadeKind, clazz[i]);
        }
    }

    public synchronized boolean fadeAllowed(FadeTracker.FadeKind fadeKind, Component comp) {
        if (this.globalAllowed.contains(fadeKind)) {
            return true;
        }
        Set specific = (Set)this.classAllowed.get(fadeKind);
        if (specific == null) {
            return false;
        }
        Class<?> clazz = comp.getClass();
        for (Class specClazz : specific) {
            if (!specClazz.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }
}

