/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;

public class SplashScreen
extends JWindow {
    private JProgressBar progress;

    public SplashScreen(ImageIcon CoolPicture, String message, String title) {
        JPanel PanelForBorder = new JPanel(new BorderLayout());
        PanelForBorder.setLayout(new BorderLayout());
        PanelForBorder.add((Component)new JLabel(CoolPicture), "Center");
        PanelForBorder.add((Component)new JLabel(title, 0), "North");
        this.progress = new JProgressBar(0, 80);
        this.progress.setStringPainted(true);
        this.progress.setString(message);
        PanelForBorder.add((Component)this.progress, "South");
        PanelForBorder.setBorder(new BevelBorder(0));
        this.getContentPane().add(PanelForBorder);
    }

    public void setVisible(boolean show) {
        if (show) {
            this.pack();
            Dimension WindowSize = this.getSize();
            Dimension ScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setBounds((ScreenSize.width - WindowSize.width) / 2, (ScreenSize.height - WindowSize.height) / 2, WindowSize.width, WindowSize.height);
        }
        super.setVisible(show);
    }

    public void showStatus(String CurrentStatus, int percent) {
        if (this.isVisible()) {
            SwingUtilities.invokeLater(new UpdateStatus(CurrentStatus, percent));
        }
    }

    public void close() {
        if (this.isVisible()) {
            SwingUtilities.invokeLater(new CloseSplashScreen());
        }
    }

    private class CloseSplashScreen
    implements Runnable {
        private CloseSplashScreen() {
        }

        public void run() {
            SplashScreen.this.setVisible(false);
            SplashScreen.this.dispose();
        }
    }

    private class UpdateStatus
    implements Runnable {
        private String message;
        private int value;

        public UpdateStatus(String status, int pc) {
            this.message = status;
            this.value = pc;
        }

        public void run() {
            SplashScreen.this.progress.setValue(this.value);
            SplashScreen.this.progress.setString(this.message);
        }
    }
}

