/*
 * Decompiled with CFR 0.152.
 */
package jas.hist.test;

import jas.hist.CustomOverlay;
import jas.hist.DataSource;
import jas.hist.ScatterEnumeration;
import jas.hist.ScatterPlotSource;
import jas.plot.DateCoordinateTransformation;
import jas.plot.DoubleCoordinateTransformation;
import jas.plot.LegendEntry;
import jas.plot.OverlayContainer;
import jas.plot.PlotGraphics;
import java.awt.Color;

class MyCustomOverlay
implements LegendEntry,
CustomOverlay {
    OverlayContainer container;
    ScatterPlotSource source;

    MyCustomOverlay() {
    }

    public void setDataSource(DataSource ds) {
        this.source = (ScatterPlotSource)ds;
    }

    public void paintIcon(PlotGraphics g, int size, int height) {
    }

    public String getTitle() {
        return this.source.getTitle();
    }

    public void paint(PlotGraphics g, boolean isPrinting) {
        DateCoordinateTransformation xtd = (DateCoordinateTransformation)this.container.getXTransformation();
        DoubleCoordinateTransformation yt = (DoubleCoordinateTransformation)this.container.getYTransformation();
        DateTransformationConverter xt = new DateTransformationConverter(xtd);
        g.setTransformation(xt, yt);
        g.setColor(Color.blue);
        ScatterEnumeration e = this.source.startEnumeration();
        double[] point = new double[2];
        double[] lastPoint = null;
        while (e.getNextPoint(point)) {
            if (lastPoint != null) {
                g.drawLine((double)lastPoint[0], (double)lastPoint[1], point[0], (double)lastPoint[1]);
            }
            g.drawSymbol(point[0], point[1], 5.0, 0);
            lastPoint = point;
            point = new double[2];
        }
    }

    public void containerNotify(OverlayContainer c) {
        this.container = c;
    }

    private class DateTransformationConverter
    implements DoubleCoordinateTransformation {
        private DateCoordinateTransformation source;

        DateTransformationConverter(DateCoordinateTransformation source) {
            this.source = source;
        }

        public double convert(double d) {
            return this.source.convert((long)(d * 1000.0));
        }

        public double unConvert(double i) {
            return (double)this.source.map(i) / 1000.0;
        }

        public double getPlotMin() {
            return (double)this.source.getAxisMin() / 1000.0;
        }

        public double getPlotMax() {
            return (double)this.source.getAxisMax() / 1000.0;
        }
    }
}

