/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DefaultFunctionFactory;
import jas.hist.FunctionFactory;
import jas.hist.FunctionFactoryError;
import jas.hist.FunctionListCellRenderer;
import jas.util.JASDialog;
import jas.util.JASState;
import jas.util.NestedRuntimeException;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JList;

public class FunctionRegistry {
    private Vector m_functions = new Vector();
    private static FunctionRegistry theFunctionRegistry = new FunctionRegistry();
    private FunctionFactory m_selection;
    private JList m_list;

    private FunctionRegistry() {
    }

    public static FunctionRegistry instance() {
        return theFunctionRegistry;
    }

    public void registerFunction(Class c, String name) {
        this.registerFunction(this.createFunctionFactory(c, name));
    }

    public FunctionFactory createFunctionFactory(Class c, String name) {
        try {
            return new DefaultFunctionFactory(c, name);
        }
        catch (FunctionFactoryError e) {
            throw new NestedRuntimeException(e);
        }
    }

    public void registerFunction(FunctionFactory f) {
        this.m_functions.addElement(f);
    }

    public void removeFunctionFactory(FunctionFactory f) {
        this.m_functions.removeElement(f);
    }

    public void removeAllFunctions() {
        this.m_functions.removeAllElements();
    }

    public Enumeration elements() {
        return this.m_functions.elements();
    }

    public int size() {
        return this.m_functions.size();
    }

    public FunctionFactory find(String name) {
        Enumeration e = this.m_functions.elements();
        while (e.hasMoreElements()) {
            FunctionFactory ff = (FunctionFactory)e.nextElement();
            if (!ff.getFunctionName().equals(name)) continue;
            return ff;
        }
        return null;
    }

    public void setContents(Vector v) {
        this.m_functions = v;
    }

    FunctionFactory chooseFunction(Frame f) {
        ChooseFunctionDialog dlg = new ChooseFunctionDialog(f);
        if (dlg.doModal()) {
            return dlg.getSelectedFunction();
        }
        return null;
    }

    private class ChooseFunctionDialog
    extends JASDialog
    implements ItemListener,
    ActionListener {
        ChooseFunctionDialog(Frame f) {
            super(f, "Choose Function...");
            FunctionRegistry.this.m_list = new JList(FunctionRegistry.this.m_functions);
            FunctionRegistry.this.m_list.setCellRenderer(new FunctionListCellRenderer());
            this.getContentPane().add("Center", FunctionRegistry.this.m_list);
            this.pack();
        }

        public void itemStateChanged(ItemEvent evt) {
            this.callEnable();
        }

        public void actionPerformed(ActionEvent evt) {
            this.onOK();
        }

        public void enableOK(JASState state) {
        }

        public void onOK() {
            FunctionRegistry.this.m_selection = (FunctionFactory)FunctionRegistry.this.m_list.getSelectedValue();
            super.onOK();
        }

        public FunctionFactory getSelectedFunction() {
            return FunctionRegistry.this.m_selection;
        }
    }
}

