% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getIndistFit.R
\name{getIndistFit}
\alias{getIndistFit}
\title{A Function that Computes Corrected Fit Indexes According to the ISAT and INULL Models of Olsen & Kenny (2006)}
\usage{
getIndistFit(indmodel, isatmod, inullmod)
}
\arguments{
\item{indmodel}{input lavaan model object fitted using dyadCFA(model = "indistinguishable")}

\item{isatmod}{input lavaan model object fitted using ISAT()}

\item{inullmod}{input lavaan model object fitted using INULL()}
}
\value{
A data frame of the original and corrected chi sq, df, p, rmsea, and tli
}
\description{
This function takes the outputted model fit using scriptCFA() with model = "indist",
as well as scriptISAT(), and scriptINULL() and computes corrected model fit indexes according
to the approach outlined by Olsen & Kenny (2006)
}
\examples{
dvn <- scrapeVarCross(dat = commitmentQ, x_order = "spi", x_stem = "sat.g", x_delim1 = ".",
x_delim2="_", distinguish_1="1", distinguish_2="2")

sat.indist.script <-  scriptCFA(dvn, lvname = "Sat")
sat.indist.mod <- lavaan::cfa(sat.indist.script, data = commitmentQ, std.lv = FALSE,
auto.fix.first= FALSE, meanstructure = TRUE)

sat.isat.script <- scriptISAT(dvn, lvxname = "Sat")
sat.isat.mod <- lavaan::cfa(sat.isat.script, data = commitmentQ, std.lv = FALSE,
auto.fix.first= FALSE, meanstructure = FALSE)

sat.inull.script <- scriptINULL(dvn, lvxname = "Sat")
sat.inull.mod <- lavaan::cfa(sat.inull.script, data = commitmentQ, std.lv = FALSE,
auto.fix.first= FALSE, meanstructure = FALSE)

getIndistFit(sat.indist.mod, sat.isat.mod, sat.inull.mod)

}
\seealso{
Other supplemental model calculators: 
\code{\link{getDyReliability}()},
\code{\link{getDydmacs}()}
}
\concept{supplemental model calculators}
