% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_request.R
\name{project_update_request}
\alias{project_update_request}
\title{Create request object to update existing projects.}
\usage{
project_update_request(title = NULL, visibility = NULL, objective = NULL,
  summary = NULL, tags = NULL, license = NULL, files = NULL,
  linked_datasets = NULL)
}
\arguments{
\item{title}{Project title.}

\item{visibility}{Project visibility, must be PRIVATE or OPEN.}

\item{objective}{(optional) Short project objective.}

\item{summary}{(optional) Long-form project summary (Markdown supported).}

\item{tags}{Character vector of project tags (letters, numbers and spaces).}

\item{license}{Dataset license ("Public Domain", "PDDL", "CC-0",
"CC-BY", "ODC-BY", "CC-BY-SA", "ODC-ODbL", "CC BY-NC-SA" or Other).}

\item{files}{(optional) List of \code{\link{file_create_request}} objects.}

\item{linked_datasets}{List of
\code{\link{linked_dataset_create_or_update_request}} objects.}
}
\value{
Request object of type \code{project_update_request}.
}
\description{
Create request object to update existing projects.
}
\examples{
request <- dwapi::project_update_request(title='My Project', visibility = 'OPEN',
  objective = 'objective', tags = c('sdk') , license = 'Public Domain')
}
\seealso{
\code{\link{update_project}}
}
