% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_file.R
\name{add_file}
\alias{add_file}
\alias{add_file.default}
\alias{add_file.file_batch_update_request}
\alias{add_file.dataset_create_request}
\alias{add_file.dataset_replace_request}
\alias{add_file.dataset_update_request}
\title{Add a file to a request object.}
\usage{
add_file(request, name, url, description = NULL, labels = NULL)

\method{add_file}{default}(request, name, url, description = NULL,
  labels = NULL)

\method{add_file}{file_batch_update_request}(request, name, url,
  description = NULL, labels = NULL)

\method{add_file}{dataset_create_request}(request, name, url,
  description = NULL, labels = NULL)

\method{add_file}{dataset_replace_request}(request, name, url,
  description = NULL, labels = NULL)

\method{add_file}{dataset_update_request}(request, name, url = NULL,
  description = NULL, labels = NULL)
}
\arguments{
\item{request}{Request object and container for files.}

\item{name}{Filename including the file extension. If a file by that name
already exists in the dataset, the file will be updated/overwritten.}

\item{url}{Source URL for file. Optional, if updating existing files.}

\item{description}{(optional) File description.}

\item{labels}{(optional) List of file labels ("raw data", "documentation",
"visualization", "clean data", "script" or "report").}
}
\value{
Modified request object.
}
\description{
Add a file to a request object.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default implementation

\item \code{file_batch_update_request}: Add a file to a file_batch_update_request objects

\item \code{dataset_create_request}: Add a file to a dataset_create_request object

\item \code{dataset_replace_request}: Add a file to a dataset_replace_request object

\item \code{dataset_update_request}: Add a file to a dataset_update_request object
}}

\examples{
file_batch_update_req <- dwapi::file_batch_update_request()

file_batch_update_req <- dwapi::add_file(request = file_batch_update_req,
  name = 'file.csv', url = 'https://data.world/file3.csv')

dataset_create_req <- dwapi::dataset_create_request(title='coffeeCounty',
  visibility = 'OPEN', description = 'coffee county , AL - census income' ,
  tags = c('rsdk', 'sdk', 'arr') , license_string = 'Public Domain')

dataset_create_req <- dwapi::add_file(request = dataset_create_req,
  name = 'file4.csv', url = 'https://data.world/file4.csv')

dataset_replace_req <- dwapi::dataset_replace_request(visibility = 'OPEN',
  description = 'updated description', files = list())

dataset_replace_req <- dwapi::add_file(request = dataset_replace_req,
  name = 'file4.csv', url = 'https://data.world/file4.csv',
  description = "My 4th csv", labels = list("clean data"))
}
