% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mse.R
\name{get_mse}
\alias{get_mse}
\title{Extract Mean Squared Error (MSE) from Fitted Regression Model}
\usage{
get_mse(model.fit, var.estimate = FALSE)
}
\arguments{
\item{model.fit}{Fitted regression model returned from 
\code{\link[stats]{lm}} or \code{\link[stats]{glm}}.}

\item{var.estimate}{If \code{TRUE}, function returns a variance estimate for 
the error variance, defined as \code{2 * MSE^2 / (n - p)}.}
}
\value{
If \code{var.estimate = FALSE}, numeric value indicating the MSE; if 
\code{var.estimate = TRUE}, named numeric vector indicating both the MSE and 
a variance estimate for the error variance.
}
\description{
The MSE, defined as the sum of the squared residuals divided by \code{n-p} 
(\code{n} = number of observations, \code{p} = number of regression 
coefficients), is an unbiased estimator for the error variance in a linear 
regression model. This is a convenience function that extracts the MSE from 
a fitted \code{\link{lm}} or \code{\link{glm}} object. The code is 
\code{rev(anova(model.fit)$"Mean Sq")[1]} if \code{model.fit} is a 
\code{\link{lm}} object and 
\code{sum(model.fit$residuals^2) / model.fit$df.residual} if \code{model.fit} 
is a \code{\link{glm}} object.
}
\examples{
# Generate 100 values: Y = 0.5 + 1.25 X + e, e ~ N(0, 1)
set.seed(123)
x <- rnorm(100)
y <- 0.5 + 1.25 * x + rnorm(100, sd = 1)

# Fit regression model using lm and using glm
lm.fit <- lm(y ~ x)
glm.fit <- glm(y ~ x)

# Extract MSE from lm.fit and glm.fit
get_mse(lm.fit)
get_mse(glm.fit)

}
