# Generated by 02-duckplyr_df-methods.R
#' @export
group_split.duckplyr_df <- function(.tbl, ..., .keep = TRUE, keep = deprecated()) {
  if (!missing(keep)) {
    lifecycle::deprecate_warn("1.0.0", "group_split(keep = )", "group_split(.keep = )", always = TRUE)
    .keep <- keep
  }

  # Our implementation
  rel_try(
    # Always fall back to dplyr
    "No relational implementation for group_split()" = TRUE,
    {
      return(out)
    }
  )

  # dplyr forward
  group_split <- dplyr$group_split.data.frame
  out <- group_split(.tbl, ..., .keep = .keep)
  return(out)

  # dplyr implementation
  if (!missing(keep)) {
    lifecycle::deprecate_warn("1.0.0", "group_split(keep = )", "group_split(.keep = )", always = TRUE)
    .keep <- keep
  }
  data <- group_by(.tbl, ...)
  group_split_impl(data, .keep = .keep)
}

duckplyr_group_split <- function(.tbl, ...) {
  try_fetch(
    .tbl <- as_duckplyr_df(.tbl),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- group_split(.tbl, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
