% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fallback.R
\name{fallback}
\alias{fallback}
\alias{fallback_sitrep}
\alias{fallback_review}
\alias{fallback_upload}
\alias{fallback_purge}
\title{Fallback to dplyr}
\usage{
fallback_sitrep()

fallback_review(oldest = NULL, newest = NULL, detail = TRUE)

fallback_upload(oldest = NULL, newest = NULL, strict = TRUE)

fallback_purge(oldest = NULL, newest = NULL)
}
\arguments{
\item{oldest, newest}{The number of oldest or newest reports to review.
If not specified, all reports are dispayed.}

\item{detail}{Print the full content of the reports.
Set to \code{FALSE} to only print the file names.}

\item{strict}{If \code{TRUE}, the function aborts if any of the reports fail to upload.
With \code{FALSE}, only a message is printed.}
}
\description{
The \pkg{duckplyr} package aims at providing
a fully compatible drop-in replacement for \pkg{dplyr}.
To achieve this, only a carefully selected subset of dplyr's operations,
R functions, and R data types are implemented.
Whenever duckplyr encounters an incompatibility, it falls back to dplyr.

To assist future development, the fallback situations can be logged
to the console or to a local file and uploaded for analysis.
By default, \pkg{duckplyr} will not log or upload anything.
The functions and environment variables on this page control the process.

\code{fallback_sitrep()} prints the current settings for fallback logging and uploading,
the number of reports ready for upload, and the location of the logs.

\code{fallback_review()} prints the available reports for review to the console.

\code{fallback_upload()} uploads the available reports to a central server for analysis.
The server is hosted on AWS and the reports are stored in a private S3 bucket.
Only authorized personnel have access to the reports.

\code{fallback_purge()} deletes some or all available reports.
}
\details{
Logging and uploading are both opt-in.
By default, for logging, a message is printed to the console
for the first time in a session and then once every 8 hours.

The following environment variables control the logging and uploading:
\itemize{
\item \code{DUCKPLYR_FALLBACK_COLLECT} controls logging, set it
to 1 or greater to enable logging.
If the value is 0, logging is disabled.
Future versions of duckplyr may start logging additional data
and thus require a higher value to enable logging.
Set to 99 to enable logging for all future versions.
Use \code{\link[usethis:edit]{usethis::edit_r_environ()}} to edit the environment file.
\item \code{DUCKPLYR_FALLBACK_VERBOSE} controls printing, set it
to \code{TRUE} or \code{FALSE} to enable or disable printing.
If the value is \code{TRUE}, a message is printed to the console
for each fallback situation.
This setting is only relevant if logging is enabled.
\item \code{DUCKPLYR_FALLBACK_AUTOUPLOAD} controls uploading, set it
to 1 or greater to enable uploading.
If the value is 0, uploading is disabled.
Currently, uploading is active if the value is 1 or greater.
Future versions of duckplyr may start logging additional data
and thus require a higher value to enable uploading.
Set to 99 to enable uploading for all future versions.
Use \code{\link[usethis:edit]{usethis::edit_r_environ()}} to edit the environment file.
\item \code{DUCKPLYR_FALLBACK_LOG_DIR} controls the location of the logs.
It must point to a directory (existing or not) where the logs will be written.
By default, logs are written to a directory in the user's cache directory
as returned by \code{tools::R_user_dir("duckplyr", "cache")}.
}

All code related to fallback logging and uploading is in the
\href{https://github.com/duckdblabs/duckplyr/blob/main/R/fallback.R}{\code{fallback.R}} and
\href{https://github.com/duckdblabs/duckplyr/blob/main/R/telemetry.R}{\code{telemetry.R}} files.
}
\examples{
fallback_sitrep()
}
