% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io-csv.R, R/io-parquet.R, R/io.R
\name{df_from_csv}
\alias{df_from_csv}
\alias{duckplyr_df_from_csv}
\alias{df_from_parquet}
\alias{duckplyr_df_from_parquet}
\alias{df_to_parquet}
\alias{df_from_file}
\alias{duckplyr_df_from_file}
\title{df_from_csv}
\usage{
df_from_csv(path, ..., options = list(), class = NULL)

duckplyr_df_from_csv(path, ..., options = list(), class = NULL)

df_from_parquet(path, ..., options = list(), class = NULL)

duckplyr_df_from_parquet(path, ..., options = list(), class = NULL)

df_to_parquet(data, path)

df_from_file(path, table_function, ..., options = list(), class = NULL)

duckplyr_df_from_file(
  path,
  table_function,
  ...,
  options = list(),
  class = NULL
)
}
\arguments{
\item{path}{Path to file or directory.}

\item{...}{These dots are for future extensions and must be empty.}

\item{options}{Arguments to the DuckDB function
indicated by \code{table_function}.}

\item{class}{An optional class to add to the data frame.
The returned object will always be a data frame.
Pass \code{class(tibble())} to create a tibble.}

\item{data}{A data frame to be written to disk.}

\item{table_function}{The name of a table-valued
DuckDB function such as \code{"read_parquet"},
\code{"read_csv"}, \code{"read_csv_auto"} or \code{"read_json"}.}
}
\value{
A data frame for \code{df_from_file()}, or a \code{duckplyr_df} for
\code{duckplyr_df_from_file()}, extended by the provided \code{class}.
}
\description{
These functions ingest data from a file using a table function.
The results are transparently converted to a data frame, but the data is only read when
the resulting data frame is actually accessed.

\code{df_from_csv()} reads a CSV file using the \code{read_csv_auto()} table function.

\code{duckplyr_df_from_csv()} is a thin wrapper around \code{df_from_csv()}
that calls \code{as_duckplyr_df()} on the output.

\code{df_from_parquet()} reads a Parquet file using the \code{read_parquet()} table function.

\code{duckplyr_df_from_parquet()} is a thin wrapper around \code{df_from_parquet()}
that calls \code{as_duckplyr_df()} on the output.

\code{df_to_parquet()} writes a data frame to a Parquet file via DuckDB.
If the data frame is a \code{duckplyr_df}, the materialization occurs outside of R.
An existing file will be overwritten.
This function requires duckdb >= 0.10.0.

\code{df_from_file()} uses arbitrary table functions to read data.
See \url{https://duckdb.org/docs/data/overview} for a documentation
of the available functions and their options.

\code{duckplyr_df_from_file()} is a thin wrapper around \code{df_from_file()}
that calls \code{as_duckplyr_df()} on the output.
}
\examples{
# Create simple CSV file
path <- tempfile(fileext = ".csv")
write.csv(data.frame(a = 1:3, b = letters[4:6]), path, row.names = FALSE)

# Reading is immediate
df <- df_from_csv(path)

# Materialization only upon access
names(df)
df$a

# Return as tibble:
df_from_file(
  path,
  "read_csv",
  options = list(delim = ",", auto_detect = TRUE),
  class = class(tibble())
)

unlink(path)

# Write a Parquet file:
path_parquet <- tempfile(fileext = ".parquet")
df_to_parquet(df, path_parquet)

# With a duckplyr_df, the materialization occurs outside of R:
df \%>\%
  as_duckplyr_df() \%>\%
  mutate(b = a + 1) \%>\%
  df_to_parquet(path_parquet)

duckplyr_df_from_parquet(path_parquet)

unlink(path_parquet)
}
