# Generated by 02-duckplyr_df-methods.R

# Needed for R <= 4.2, can't use @export here:
on_load({
  vctrs::s3_register("dplyr::filter", "duckplyr_df")
})

filter.duckplyr_df <- function(.data, ..., .by = NULL, .preserve = FALSE) {
  force(.data)

  dots <- dplyr_quosures(...)
  check_filter(dots)

  by <- enquo(.by)

  rel_try(
    "Can't use relational with zero-column result set." = (length(.data) == 0),
    "Can't use relational without filter conditions." = (length(dots) == 0),
    "Can't use relational with grouped operation." = (!quo_is_null(by)), # (length(by$names) > 0),
    {
      exprs <- rel_translate_dots(dots, .data)
      rel <- duckdb_rel_from_df(.data)
      out_rel <- rel_filter(rel, exprs)
      out <- rel_to_df(out_rel)
      out <- dplyr_reconstruct(out, .data)
      return(out)
    }
  )

  # dplyr forward
  filter <- dplyr$filter.data.frame
  out <- filter(.data, ..., .by = {{ .by }}, .preserve = .preserve)
  return(out)

  # dplyr implementation
  dots <- dplyr_quosures(...)
  check_filter(dots)

  by <- compute_by(
    by = {{ .by }},
    data = .data,
    by_arg = ".by",
    data_arg = ".data"
  )

  loc <- filter_rows(.data, dots, by)
  dplyr_row_slice(.data, loc, preserve = .preserve)
}

duckplyr_filter <- function(.data, ...) {
  try_fetch(
    .data <- as_duckplyr_df(.data),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- filter(.data, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
