% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cached_connection.R
\name{cached_connection}
\alias{cached_connection}
\title{create a cachable duckdb connection}
\usage{
cached_connection(dbdir = ":memory:", read_only = FALSE)
}
\arguments{
\item{dbdir}{Location for database files. Should be a path to an existing
directory in the file system. With the default (or \code{""}), all
data is kept in RAM.}

\item{read_only}{Set to \code{TRUE} for read-only operation.
For file-based databases, this is only applied when the database file is opened for the first time.
Subsequent connections (via the same \code{drv} object or a \code{drv} object pointing to the same path)
will silently ignore this flag.}
}
\value{
a \code{\link[duckdb:duckdb]{duckdb::duckdb()}} connection object
}
\description{
This function is primarily intended for internal use by other
\code{duckdbfs} functions.  However, it can be called directly by
the user whenever it is desirable to have direct access to the
connection object.
}
\details{
When first called (by a user or internal function),
this function both creates a duckdb connection and places
that connection into a cache (\code{duckdbfs_conn} option).
On subsequent calls, this function returns the cached connection,
rather than recreating a fresh connection.

This frees the user from the responsibility of managing a
connection object, because functions needing access to the
connection can use this to create or access the existing connection.
At the close of the global environment, this function's finalizer
should gracefully shutdown the connection before removing the cache.
}
\examples{

con <- cached_connection()
close_connection(con)

}
