% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CENTROIDS-pam.R
\name{pam_cent}
\alias{pam_cent}
\title{Centroid for partition around medoids}
\usage{
pam_cent(series, distance, ids = seq_along(series), distmat = NULL, ...,
  error.check = TRUE)
}
\arguments{
\item{series}{The time series in one of the formats accepted by \code{\link[=tslist]{tslist()}}.}

\item{distance}{A character indicating which distance to use. Only needed if \code{distmat} is \code{NULL}.
The distance must be registered in \code{\link[proxy:pr_DB]{proxy::pr_DB()}}.}

\item{ids}{Integer vector indicating which of the \code{series} should be considered.}

\item{distmat}{Optionally, a pre-computed cross-distance matrix of \emph{all} \code{series}.}

\item{...}{Any extra parameters for the `distance`` function that may be used.}

\item{error.check}{Logical indicating whether the function should try to detect inconsistencies
and give more informative errors messages. Also used internally to avoid repeating checks.}
}
\value{
The medoid time series.
}
\description{
Extract the medoid time series based on a distance measure.
}
\details{
The medoid's index is determined by taking the \eqn{arg min} of the \code{distmat}'s row-sums
(considering only the rows in \code{ids}). The distance matrix is calculated if needed.
}
\examples{

pam_cent(CharTraj, "dtw_basic", ids = 6L:10L, window.size = 15L)

}
