% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscellaneous.R
\docType{methods}
\name{Assessment}
\alias{Assessment}
\alias{splitDataset}
\alias{splitDataset,twdtwTimeSeries-method}
\alias{twdtwAssess}
\alias{twdtwAssess,list-method}
\title{Classification assessment}
\usage{
\S4method{splitDataset}{twdtwTimeSeries}(object, times = 1, p = 0.1, ...)

\S4method{twdtwAssess}{list}(object, matrix = FALSE)
}
\arguments{
\item{object}{an object of class \code{\link[dtwSat]{twdtwTimeSeries}} or 
\code{\link[dtwSat]{twdtwMatches}}.}

\item{times}{Number of partitions to create.}

\item{p}{the percentage of data that goes to training. 
See \code{\link[caret]{createDataPartition}} for details.}

\item{...}{Other arguments to be passed to \code{\link[dtwSat]{createPatterns}}.}

\item{matrix}{logical. If TRUE retrieves the confusion matrix. 
FALSE retrieves User's Accuracy (UA) and Producer's Accuracy (PA). 
Dafault is FALSE.}
}
\description{
This functions create data partitions and compute assessment metrics.
}
\details{
\describe{
 \item{\code{splitDataset}:}{This function splits the a set of time 
       series into training and validation. The function uses stratified 
       sampling and a simple random sampling for each stratum. Each data partition 
       returned by this function has the temporal patterns and a set of time series for 
       validation.}
 \item{\code{twdtwAssess}:}{The function \code{splitDataset} performs the assessment of 
       the classification based on the labels of the classified time series 
       (Reference) and the labels of the classification (Predicted). This function
       returns a data.frame with User's and Produce's Accuracy or a list for confusion 
       matrices.}
}
}
\examples{
\dontrun{
load(system.file("lucc_MT/field_samples_ts.RData", package="dtwSat"))
set.seed(1)
partitions = splitDataset(field_samples_ts, p=0.1, times=5, 
                          freq = 8, formula = y ~ s(x, bs="cc"))
log_fun = logisticWeight(alpha=-0.1, beta=50) 
twdtw_res = lapply(partitions, function(x){
   res = twdtwApply(x = x$ts, y = x$patterns, weight.fun = log_fun, n=1)
   twdtwClassify(x = res)
})
assessment = twdtwAssess(twdtw_res)
head(assessment, 5)
}
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
\seealso{
\code{\link[dtwSat]{twdtwMatches-class}},
\code{\link[dtwSat]{twdtwApply}}, and 
\code{\link[dtwSat]{twdtwClassify}}.
}

