% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tz.R
\name{dtt_adjust_tz}
\alias{dtt_adjust_tz}
\alias{dtt_adjust_tz.POSIXct}
\title{Adjust Time Zone}
\usage{
dtt_adjust_tz(x, tz = dtt_default_tz(), ...)

\method{dtt_adjust_tz}{POSIXct}(x, tz = dtt_default_tz(), ...)
}
\arguments{
\item{x}{A POSIXct vector.}

\item{tz}{A string of the time zone.}

\item{...}{Unused.}
}
\value{
The date time vector with the new time zone and time.
}
\description{
Adjusts the time zone so that clock (but not the actual) time is altered
for a date time vector.
Equivalent to \code{lubridate::with_tz()}.
}
\section{Methods (by class)}{
\itemize{
\item \code{dtt_adjust_tz(POSIXct)}: Adjust the time zone for a POSIXct vector

}}
\examples{
dtt_adjust_tz(as.POSIXct("1970-01-01", tz = "Etc/GMT+8"), tz = "UTC")
}
\seealso{
\code{\link[=dtt_set_tz]{dtt_set_tz()}}

Other tz: 
\code{\link{dtt_set_tz}()},
\code{\link{dtt_sys_tz}()},
\code{\link{dtt_tz}()}
}
\concept{tz}
