% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R, R/hour.R, R/set.R
\name{dtt_hours}
\alias{dtt_hours}
\alias{dtt_hours<-}
\alias{dtt_hour}
\alias{dtt_hour<-}
\alias{dtt_hour.Date}
\alias{dtt_hour.POSIXct}
\alias{dtt_hour.hms}
\alias{dtt_hour<-.POSIXct}
\alias{dtt_hour<-.hms}
\alias{dtt_set_hour}
\title{Get and Set Hour Values}
\usage{
dtt_hours(x, ...)

dtt_hours(x) <- value

dtt_hour(x, ...)

dtt_hour(x) <- value

\method{dtt_hour}{Date}(x, ...)

\method{dtt_hour}{POSIXct}(x, ...)

\method{dtt_hour}{hms}(x, ...)

\method{dtt_hour}{POSIXct}(x) <- value

\method{dtt_hour}{hms}(x) <- value

dtt_set_hour(x, value)
}
\arguments{
\item{x}{A date/time vector.}

\item{...}{Unused.}

\item{value}{A integer vector of the hour value(s).}
}
\value{
An integer vector (or the modified date/time vector).
}
\description{
Gets and sets hour values for date/time vectors.
}
\section{Methods (by class)}{
\itemize{
\item \code{Date}: Get integer vector of hour values for a Date vector

\item \code{POSIXct}: Get integer vector of hour values for a POSIXct vector

\item \code{hms}: Get integer vector of hour values for a hms vector

\item \code{POSIXct}: Set hour values for a POSIXct vector

\item \code{hms}: Set hour values for a hms vector
}}

\examples{
x <- as.POSIXct("1990-01-02 23:40:51")
dtt_hour(x)
dtt_hour(x) <- 01L
x

x <- hms::as_hms("23:40:51")
dtt_hour(x)
dtt_hour(x) <- 01L
x
}
