% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtrackr.R
\name{p_slice_sample}
\alias{p_slice_sample}
\title{Slice operations}
\usage{
p_slice_sample(
  .data,
  ...,
  .messages = c("{.count.in} before", "{.count.out} after"),
  .headline = "slice data"
)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{...}{
  Arguments passed on to \code{\link[dplyr:slice]{dplyr::slice_sample}}
  \describe{
    \item{\code{n,prop}}{Provide either \code{n}, the number of rows, or \code{prop}, the
proportion of rows to select. If neither are supplied, \code{n = 1} will be
used. If \code{n} is greater than the number of rows in the group
(or \code{prop > 1}), the result will be silently truncated to the group size.
\code{prop} will be rounded towards zero to generate an integer number of
rows.

A negative value of \code{n} or \code{prop} will be subtracted from the group
size. For example, \code{n = -2} with a group of 5 rows will select 5 - 2 = 3
rows; \code{prop = -0.25} with 8 rows will select 8 * (1 - 0.25) = 6 rows.}
    \item{\code{weight_by}}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> Sampling weights.
This must evaluate to a vector of non-negative numbers the same length as
the input. Weights are automatically standardised to sum to 1.}
    \item{\code{replace}}{Should sampling be performed with (\code{TRUE}) or without
(\code{FALSE}, the default) replacement.}
  }}

\item{.messages}{a set of glue specs. The glue code can use any global
variable, \{.count.in\}, \{.count.out\} for the input and output dataframes
sizes respectively and \{.excluded\} for the difference}

\item{.headline}{a glue spec. The glue code can use any global variable,
\{.count.in\}, \{.count.out\} for the input and output dataframes sizes
respectively.}
}
\value{
the sliced dataframe with the history graph updated.
}
\description{
Slice operations behave as in dplyr, except the history graph can be updated with
tracked dataframe with the before and after sizes of the dataframe.
See \code{\link[dplyr:slice]{dplyr::slice()}}, \code{\link[dplyr:slice]{dplyr::slice_head()}}, \code{\link[dplyr:slice]{dplyr::slice_tail()}},
\code{\link[dplyr:slice]{dplyr::slice_min()}}, \code{\link[dplyr:slice]{dplyr::slice_max()}}, \code{\link[dplyr:slice]{dplyr::slice_sample()}},
for more details on the underlying functions.
}
\examples{
library(dplyr)
library(dtrackr)

# In this example the iris dataframe is resampled 100 times with replacement
# within each group and the
iris \%>\%
  track() \%>\%
  group_by(Species) \%>\%
  slice_sample(n=100, replace=TRUE,
               .messages="{.count.out} / {.count.in} = {n}",
               .headline="100 {Species}") \%>\%
  history()
}
\seealso{
dplyr::slice_sample()
}
