% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsmodel.R
\name{dsmodel}
\alias{dsmodel}
\title{Defines a model object encapsulating a dynamical system}
\usage{
dsmodel(fun, title = "", display = TRUE)
}
\arguments{
\item{fun}{Function with two inputs and two outputs which defines the dynamical system. The output should be a list, preferably with field names x and y.}

\item{title}{A string title for the graph. Text can be input in the form of pseudo-LaTeX code within quotes.
See \code{\link[latex2exp]{TeX}} for more details.}

\item{display}{If set to \code{FALSE}, the model will be drawn only when the user calls \code{`MODELNAME`$display()}. Otherwise,
the model will be drawn with every \code{dsmodels} object added after the \code{dsrange} is added.}
}
\description{
To begin, define a two dimensional function that outputs
a two-dimensional list. For instance:
\code{fun <- function(x,y) list(x,y)}. Then
\code{dsmodel(fun)} will initialize the model.
\strong{Make sure that the function defining your model indeed outputs a \code{list}.}
The model is used to hold the data for graphics.
To display a desired graphic, add the corresponding
feature of type "dsproto" to your model.
}
\details{
Models are constructed
incrementally using the + operator to add features
to the existing dsmodel object. A \code{\link{dsrange}} must be one of the objects added to a model.
}
\section{Methods}{

\code{dsmodel} objects support the following methods, which may be helpful for advanced users.

\code{dsmodel$points(format="list", filter="all")} returns a list of the points in the model.
\describe{
\item{\code{filter}}{Valid values are \code{"all"}, \code{"fixed"}, \code{"attractor"}, and \code{"sim"}.
 \code{"sim"} returns only points generated by \code{\link{simattractors}}. }
\item{\code{format}}{If \code{"list"}, return a list with \code{x}, \code{y}, \code{col}, and \code{ind} fields holding
 the coordinates, color, and index. Other formats are \code{"objects"}, returning a vector of \code{dspoint} objects,
 and \code{"pairs"}, returning a list of pairs of coordinates.}
}

\code{dsmodel$display()} forces the model to re-render the plot from scratch. Primarily useful if \code{display=TRUE} was set.

\code{dsmodel$basins()} returns a list of which fixed points have a basin. This requires \code{simbasins()} to have been composed
with the model, and is primarily useful when testing if a dynamical system is globally stable. In that case, the method
will return a list of length 1. The list will contain the indices of the fixed points, as given in
\code{dsmodel$points(format="list", filter="attractor")}. An index of 0 means that some points never moved within
epsilon of an attractor.

\code{dsmodel$sim.is.stable()} attempts to determine if the system is stable by simulation. If no attractors have
been composed with the model, \code{simattractors()} is composed with defaults. If \code{simbasins} has not
been composed with the model, it is be composed with defaults. If every point is drawn to a single attractor, the
system has been deemed stable. Note that boundary points on the range will not be tested.
}

\examples{
library(dsmodels)

fun <- function(X,Y) {
  list(
    x = X/exp(Y),
    y = Y/exp(X)
  )
}
# Add dsRange to see the actual range.
model <- dsmodel(fun)

dsmodel(function(x,y) {
  list(
    x = x^2,
    y = x/(y+1)
  )
}, title = "Another function showing $f(x)=x^{\\\\alpha}$!")
}
\seealso{
\code{\link{dsrange}}
}
