% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decompose_itemnames.R
\name{decompose_itemnames}
\alias{decompose_itemnames}
\title{Decomposes item names into their four components}
\usage{
decompose_itemnames(x)
}
\arguments{
\item{x}{A character vector containing item names (gcdg lexicon)}
}
\value{
A \code{data.frame} with \code{length(x)} rows and
four columns, named: \code{instrument}, \code{domain}, \code{mode},
and \code{number}.
}
\description{
This utility function decomposes item names into components:
instrument, domain, mode and number
}
\details{
The gsed-naming convention is as follows. Position 1-3 codes the
instrument, position 4-5 codes the domain, position 6 codes
direct/caregiver/message, positions 7-9 is a item sequence number.
}
\examples{
itemnames <- c("aqigmc028", "grihsd219", "", "by1mdd157", "mdsgmd006")
decompose_itemnames(itemnames)
}
\references{
\url{https://docs.google.com/spreadsheets/d/1zLsSW9CzqshL8ubb7K5R9987jF4YGDVAW_NBw1hR2aQ/edit#gid=0}
}
\seealso{
\code{\link[=sort_itemnames]{sort_itemnames()}}
}
\author{
Stef van Buuren
}
